/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import java.util.ArrayList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SinoceratopsEntity;

@OnlyIn(value=Dist.CLIENT)
public class SinoceratopsAnimator
extends EntityAnimator<SinoceratopsEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, SinoceratopsEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox body1 = model.getCube("body 1");
        AdvancedModelBox body2 = model.getCube("body 2");
        AdvancedModelBox body3 = model.getCube("body 3");
        AdvancedModelBox neck = model.getCube("neck");
        AdvancedModelBox head = model.getCube("head");
        AdvancedModelBox tail1 = model.getCube("tail 1");
        AdvancedModelBox tail2 = model.getCube("tail 2");
        AdvancedModelBox tail3 = model.getCube("tail 3");
        AdvancedModelBox tail4 = model.getCube("tail 4");
        AdvancedModelBox tail5 = model.getCube("tail 5");
        AdvancedModelBox tail6 = model.getCube("tail 6");
        AdvancedModelBox tail7 = model.getCube("tail 7");
        AdvancedModelBox frillConn = model.getCube("frill connection");
        AdvancedModelBox frillMidT = model.getCube("frill middle top");
        AdvancedModelBox frillRT = model.getCube("frill right top");
        AdvancedModelBox frillLT = model.getCube("frill left top");
        AdvancedModelBox[] torso = SinoceratopsAnimator.arr(body1, body2, body3);
        AdvancedModelBox[] neckChain = SinoceratopsAnimator.arr(head, neck);
        AdvancedModelBox[] tail = SinoceratopsAnimator.arr(tail7, tail6, tail5, tail4, tail3, tail2, tail1);
        AdvancedModelBox[] frillSet = SinoceratopsAnimator.arr(frillMidT, frillRT, frillLT);
        float idleSpeed = 0.1f;
        float idleDegree = 0.08f;
        if (body1 != null) {
            model.bob(body1, idleSpeed, 0.55f, false, ticks, 1.0f);
        }
        if (torso.length > 1) {
            model.chainWave(torso, idleSpeed * 0.65f, idleDegree * 0.45f, 2.0, ticks, 1.0f);
        }
        if (neckChain.length > 0) {
            model.chainWave(neckChain, idleSpeed * 0.6f, idleDegree * 0.55f, -2.0, ticks, 1.0f);
        }
        if (head != null) {
            model.chainSwing(new AdvancedModelBox[]{head}, idleSpeed * 0.9f, 0.1f, 0.0, ticks, 1.0f);
            model.bob(head, idleSpeed, 0.035f, false, ticks, 1.0f);
        }
        if (tail.length > 0) {
            model.chainSwing(tail, idleSpeed, 0.16f, -2.0, ticks, 1.0f);
            if (limbSwingAmount > 0.12f) {
                model.chainSwing(tail, 0.55f, 0.12f, -2.0, limbSwing, limbSwingAmount);
            }
            entity.tailBuffer.applyChainSwingBuffer(tail);
        }
        if (frillSet.length > 0) {
            model.chainWave(frillSet, idleSpeed * 1.2f, 0.04f, 2.0, ticks, 1.0f);
            model.chainSwing(frillSet, idleSpeed * 1.1f, 0.05f, 2.0, ticks, 1.0f);
        }
        if (frillConn != null) {
            model.chainWave(new AdvancedModelBox[]{frillConn}, idleSpeed, 0.02f, 0.0, ticks, 1.0f);
        }
        if (neck != null || head != null) {
            model.faceTarget(rotationYaw, rotationPitch, 0.85f, SinoceratopsAnimator.arr(neck, head));
        }
    }

    private static AdvancedModelBox[] arr(AdvancedModelBox ... parts) {
        ArrayList<AdvancedModelBox> out = new ArrayList<AdvancedModelBox>();
        for (AdvancedModelBox p : parts) {
            if (p == null) continue;
            out.add(p);
        }
        return out.toArray(new AdvancedModelBox[0]);
    }
}

