/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.vehicle;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.vehicle.InterpValue;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;

public class CarAnimator
implements ITabulaModelAnimator<VehicleEntity> {
    private final List<Door> doors = Lists.newArrayList();
    public float partialTicks;

    public CarAnimator addDoor(Door d) {
        this.doors.add(d);
        return this;
    }

    public void setRotationAngles(TabulaModel model, VehicleEntity car, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch, float scale) {
        float steer;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Vec3 playerPos = player.m_20182_();
            VehicleEntity.Seat closest = this.doors.stream().map(d -> d.getSeat(car)).min((s1, s2) -> Double.compare(s1.getPos(car).m_82554_(playerPos), s2.getPos(car).m_82554_(playerPos))).orElse(null);
            for (Door d2 : this.doors) {
                boolean open;
                InterpValue value = d2.getInterpValue(car);
                boolean bl = open = !player.m_5833_() && !car.m_20197_().contains(player) && car.getEntityInSeat(d2.seatIndex) == null && closest == d2.getSeat(car) && closest.getPos(car).m_82554_(playerPos) <= 4.0;
                value.setTarget(Math.toRadians(open ? (double)(d2.isLeft ? 60 : -60) : 0.0));
                model.getCube((String)d2.name).rotateAngleY = (float)value.getValueForRendering(this.partialTicks);
            }
        }
        AdvancedModelBox wheelHolderFront = model.getCube("wheel holder front");
        AdvancedModelBox wheelHolderBack = model.getCube("wheel holder back");
        float rot = car.prevWheelRotateAmount + (car.wheelRotateAmount - car.prevWheelRotateAmount) * this.partialTicks;
        float rotAmount = car.wheelRotation - car.wheelRotateAmount * (1.0f - this.partialTicks);
        if (car.backward()) {
            rotAmount = -rotAmount;
        }
        wheelHolderFront.rotateAngleX = rotAmount * 0.5f;
        wheelHolderBack.rotateAngleX = rotAmount * 0.5f;
        car.steerAmount.setTarget(Math.toRadians(car.left() ? 40.0 : (car.right() ? -40.0 : 0.0)));
        model.getCube((String)"steering wheel main").rotateAngleZ = steer = (float)car.steerAmount.getValueForRendering(this.partialTicks);
        wheelHolderFront.rotateAngleY = -steer * 0.15f;
    }

    public static final class Door {
        private final String name;
        private final int seatIndex;
        private final boolean isLeft;

        public Door(String boneName, int seatIndex, boolean leftSide) {
            this.name = boneName;
            this.seatIndex = seatIndex;
            this.isLeft = leftSide;
        }

        public InterpValue getInterpValue(VehicleEntity car) {
            return this.getSeat(car).getInterpValue();
        }

        public VehicleEntity.Seat getSeat(VehicleEntity car) {
            return car.getSeat(this.seatIndex);
        }
    }
}

