/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASynthesizer;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNASynthesizer.DNASynthesizerMenu;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.inventory.DNASynthesizerHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.util.api.SynthesizableItem;
import org.jetbrains.annotations.NotNull;

public class DNASynthesizerBlockEntity
extends MachineBlockEntity
implements ItemHandlerBlockEntity,
MenuProvider {
    public static final int SLOTS = 7;
    public static final int[] INPUTS = new int[]{0, 1, 2};
    public static final int[] OUTPUTS = new int[]{3, 4, 5, 6};
    private int synthesizeTime = 0;
    protected final DNASynthesizerHandler machineItemStackHandler = new DNASynthesizerHandler(7, INPUTS, OUTPUTS);
    public ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return DNASynthesizerBlockEntity.this.synthesizeTime;
            }
            return -1;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                DNASynthesizerBlockEntity.this.synthesizeTime = pValue;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public DNASynthesizerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DNA_SYNTHESIZER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @Override
    public Tag getMachineData() {
        CompoundTag machineData = new CompoundTag();
        machineData.m_128405_("SynthesizeTime", this.synthesizeTime);
        return machineData;
    }

    @Override
    public void readMachineData(Tag data) {
        CompoundTag machineData = (CompoundTag)data;
        this.synthesizeTime = machineData.m_128451_("SynthesizeTime");
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.jurassicreborn.dna_synthesizer");
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new DNASynthesizerMenu(pContainerId, this.machineItemStackHandler, this.data, pInventory);
    }

    public int getOpenOutput(ItemStack output) {
        for (int i : OUTPUTS) {
            if (!this.getItem(i).m_41619_() && (!ItemStack.m_150942_((ItemStack)output, (ItemStack)this.getItem(i)) || !ItemStack.m_150942_((ItemStack)this.getItem(i), (ItemStack)output))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasSpace() {
        for (int i : OUTPUTS) {
            if (!this.getItem(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        ItemStack storageDisc = this.getItem(0);
        ItemStack output = SynthesizableItem.getSynthesizableItem(storageDisc).getSynthesizedItem(storageDisc, this.f_58857_.m_213780_());
        int outputSlot = this.getOpenOutput(output);
        if (outputSlot != -1) {
            this.mergeStack(outputSlot, output);
            ItemStack tube = this.getItem(1);
            ItemStack dnaBaseMaterial = this.getItem(2);
            tube.m_41774_(1);
            dnaBaseMaterial.m_41774_(1);
            this.setItem(1, tube);
            this.setItem(2, dnaBaseMaterial);
        }
        return List.of(ItemStack.f_41583_);
    }

    public static void tick(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull DNASynthesizerBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        if (!pBlockEntity.canProcess(new ItemStack[0])) {
            pBlockEntity.synthesizeTime = 0;
            return;
        }
        ++pBlockEntity.synthesizeTime;
        if (pBlockEntity.synthesizeTime >= 2000) {
            pBlockEntity.processItem(new ItemStack[0]);
            pBlockEntity.synthesizeTime = 0;
        }
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        return this.getItem(0).m_41720_() == ModItems.STORAGE_DISC.get() && this.getItem(1).m_41720_() == ModItems.EMPTY_TEST_TUBE.get() && this.getItem(2).m_41720_() == ModItems.DNA_NUCLEOTIDES.get();
    }
}

