/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.vit.jurassicreborn.client.screens.HologramSelectScreen;
import net.vit.jurassicreborn.common.blocks.entities.HologramBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83144_();

    public HologramBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new HologramBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            this.openClientGui(pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void openClientGui(BlockPos pos) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.doOpenScreen(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doOpenScreen(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        BlockEntity be = mc.f_91073_.m_7702_(pos);
        int current = 0;
        int pose = 0;
        boolean rotating = true;
        int rotation = 0;
        if (be instanceof HologramBlockEntity) {
            HologramBlockEntity hologram = (HologramBlockEntity)be;
            current = hologram.getDinoIndex();
            pose = hologram.getPoseIndex();
            rotating = hologram.isRotating();
            rotation = hologram.getRot();
        }
        mc.m_91152_((Screen)new HologramSelectScreen(pos, current, pose, rotating, rotation));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos1, state1, be) -> {
            if (be instanceof HologramBlockEntity) {
                HologramBlockEntity hologram = (HologramBlockEntity)be;
                hologram.tick(lvl, pos1, state1, hologram);
            }
        };
    }
}

