/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.blocks.entities.ActionFigureBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class HologramBlockEntity
extends ActionFigureBlockEntity {
    public static final int ROTATION_STEP_DEGREES = 45;
    private static final String TAG_DINO_INDEX = "DinoIndex";
    private static final String TAG_POSE_INDEX = "PoseIndex";
    private static final String TAG_ROTATING = "Rotating";
    private static final String TAG_ROTATION = "Rotation";
    private int dinoIndex;
    private int poseIndex;
    private boolean rotating = true;

    public static int snapRotation(int rotation) {
        int snapped = (int)Math.round((double)rotation / 45.0) * 45;
        return Math.floorMod(snapped, 360);
    }

    public HologramBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ActionFigureBlockEntity>)((BlockEntityType)ModBlockEntities.HOLOGRAM_BLOCK_ENTITY.get()), pos, state);
    }

    public void cycle(boolean reverse) {
        DinosaurHandler.doDinosInit();
        int count = DinosaurHandler.count();
        this.dinoIndex = (this.dinoIndex + (reverse ? -1 : 1) + count) % count;
        Dinosaur dino = DinosaurHandler.getById(this.dinoIndex);
        this.setDinosaur(dino, true, false, false);
        this.applyPose();
    }

    @Override
    public void setDinosaur(Dinosaur dino, boolean gender, boolean isSkeleton, boolean isFossile) {
        super.setDinosaur(dino, gender, isSkeleton, isFossile);
        this.dinoIndex = DinosaurHandler.getId(dino);
    }

    public void setDinosaurById(int id) {
        DinosaurHandler.doDinosInit();
        int count = DinosaurHandler.count();
        this.dinoIndex = Math.floorMod(id, count);
        Dinosaur dino = DinosaurHandler.getById(this.dinoIndex);
        this.setDinosaur(dino, true, false, false);
        this.applyPose();
    }

    public int getDinoIndex() {
        return this.dinoIndex;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        DinosaurHandler.doDinosInit();
        this.setDinosaur(DinosaurHandler.getById(this.dinoIndex), true, false, false);
        this.applyPose();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        int storedRotation;
        int storedIndex;
        super.m_142466_(tag);
        DinosaurHandler.doDinosInit();
        int dinoCount = Math.max(DinosaurHandler.count(), 1);
        int resolvedIndex = storedIndex = tag.m_128425_(TAG_DINO_INDEX, 3) ? tag.m_128451_(TAG_DINO_INDEX) : -1;
        if (resolvedIndex < 0 || DinosaurHandler.getById(resolvedIndex) == Dinosaur.EMPTY) {
            Dinosaur saved = Dinosaur.getDinosaurByName(tag.m_128461_("Dinosaur"));
            resolvedIndex = DinosaurHandler.getId(saved);
        }
        this.dinoIndex = Math.floorMod(resolvedIndex, dinoCount);
        int poseCount = Math.max(EntityAnimation.values().length, 1);
        this.poseIndex = Math.floorMod(tag.m_128451_(TAG_POSE_INDEX), poseCount);
        this.rotating = !tag.m_128441_(TAG_ROTATING) || tag.m_128471_(TAG_ROTATING);
        int n = storedRotation = tag.m_128425_(TAG_ROTATION, 3) ? tag.m_128451_(TAG_ROTATION) : 0;
        if (!this.rotating) {
            storedRotation = HologramBlockEntity.snapRotation(storedRotation);
        }
        this.setRotationSilently(storedRotation);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_DINO_INDEX, this.dinoIndex);
        tag.m_128405_(TAG_POSE_INDEX, this.poseIndex);
        tag.m_128379_(TAG_ROTATING, this.rotating);
        tag.m_128405_(TAG_ROTATION, this.getRot());
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, ActionFigureBlockEntity blockEntity) {
        if (level.f_46443_) {
            if (this.rotating) {
                this.setRot((this.getRot() + 2) % 360);
            }
            this.applyPose();
        }
    }

    public int getPoseIndex() {
        return this.poseIndex;
    }

    public void setPoseIndex(int poseIndex) {
        int count = EntityAnimation.values().length;
        this.poseIndex = Math.floorMod(poseIndex, count);
        this.applyPose();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isRotating() {
        return this.rotating;
    }

    public void setRotating(boolean rotating) {
        this.rotating = rotating;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public EntityAnimation getPoseAnimation() {
        EntityAnimation[] values = EntityAnimation.values();
        return values[Math.floorMod(this.poseIndex, values.length)];
    }

    @Override
    public void setRot(int rotation) {
        super.setRot(this.rotating ? rotation : HologramBlockEntity.snapRotation(rotation));
    }

    private void applyPose() {
        DinosaurEntity entity;
        if (this.f_58857_ != null && (entity = this.getEntity()) != null) {
            entity.setAnimation(this.getPoseAnimation().get());
        }
    }
}

