/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemHandlerSideWrapper;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import net.vit.jurassicreborn.common.blocks.inventory.FluidHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.SerializableSingleFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity
extends BlockEntity
implements Nameable {
    private LazyOptional<IItemHandlerModifiable> itemHandlerCapability = LazyOptional.empty();
    private LazyOptional<IFluidHandler> fluidHandlerCapability = LazyOptional.empty();
    private final EnumMap<Direction, LazyOptional<IItemHandler>> sidedItemHandlerCapabilities = new EnumMap(Direction.class);

    protected MachineBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    private void updateCapabilities() {
        MachineBlockEntity machineBlockEntity = this;
        if (machineBlockEntity instanceof ItemHandlerBlockEntity) {
            ItemHandlerBlockEntity itemHandlerBlockEntity = (ItemHandlerBlockEntity)((Object)machineBlockEntity);
            IItemHandlerModifiable handler = itemHandlerBlockEntity.getItemHandler();
            this.itemHandlerCapability = LazyOptional.of(() -> handler);
            this.sidedItemHandlerCapabilities.values().forEach(LazyOptional::invalidate);
            this.sidedItemHandlerCapabilities.clear();
            if (handler instanceof MachineItemStackHandler) {
                MachineItemStackHandler machineHandler = (MachineItemStackHandler)handler;
                for (Direction direction : Direction.values()) {
                    this.sidedItemHandlerCapabilities.put(direction, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new MachineItemHandlerSideWrapper(machineHandler, direction)));
                }
            }
        } else {
            this.itemHandlerCapability = LazyOptional.empty();
            this.sidedItemHandlerCapabilities.values().forEach(LazyOptional::invalidate);
            this.sidedItemHandlerCapabilities.clear();
        }
        machineBlockEntity = this;
        if (machineBlockEntity instanceof FluidHandlerBlockEntity) {
            FluidHandlerBlockEntity fluidHandlerBlockEntity = (FluidHandlerBlockEntity)((Object)machineBlockEntity);
            this.fluidHandlerCapability = LazyOptional.of(fluidHandlerBlockEntity::getFluidHandler);
        } else {
            this.fluidHandlerCapability = LazyOptional.empty();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.updateCapabilities();
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCaps();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.updateCapabilities();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCapability.invalidate();
        this.fluidHandlerCapability.invalidate();
        this.sidedItemHandlerCapabilities.values().forEach(LazyOptional::invalidate);
        this.sidedItemHandlerCapabilities.clear();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && this instanceof ItemHandlerBlockEntity) {
            LazyOptional<IItemHandler> sidedHandler;
            if (side != null && (sidedHandler = this.sidedItemHandlerCapabilities.get(side)) != null) {
                if (!sidedHandler.isPresent()) {
                    this.updateCapabilities();
                    sidedHandler = this.sidedItemHandlerCapabilities.get(side);
                }
                if (sidedHandler != null) {
                    return sidedHandler.cast();
                }
            }
            if (!this.itemHandlerCapability.isPresent()) {
                this.updateCapabilities();
            }
            return this.itemHandlerCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this instanceof FluidHandlerBlockEntity) {
            if (!this.fluidHandlerCapability.isPresent()) {
                this.updateCapabilities();
            }
            return this.fluidHandlerCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract Tag getMachineData();

    public abstract void readMachineData(Tag var1);

    @NotNull
    public Component m_7755_() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return this.getDefaultName();
    }

    protected abstract Component getDefaultName();

    public void m_183515_(CompoundTag pTag) {
        ItemHandlerBlockEntity itemHandlerBlockEntity;
        IItemHandlerModifiable iItemHandlerModifiable;
        MachineBlockEntity machineBlockEntity;
        super.m_183515_(pTag);
        CompoundTag machineData = new CompoundTag();
        Tag tag = this.getMachineData();
        if (tag != null) {
            machineData.m_128365_("Data", tag);
        }
        if ((machineBlockEntity = this) instanceof ItemHandlerBlockEntity && (iItemHandlerModifiable = (itemHandlerBlockEntity = (ItemHandlerBlockEntity)((Object)machineBlockEntity)).getItemHandler()) instanceof ItemStackHandler) {
            ItemStackHandler handler = (ItemStackHandler)iItemHandlerModifiable;
            machineData.m_128365_("item_inventory", (Tag)handler.serializeNBT());
        }
        pTag.m_128365_("MachineData", (Tag)machineData);
    }

    public void m_142466_(CompoundTag pTag) {
        FluidHandlerBlockEntity fluidHandlerBlockEntity;
        IFluidHandler itemInventoryTag;
        MachineBlockEntity handler;
        ItemHandlerBlockEntity itemHandlerBlockEntity;
        IItemHandlerModifiable iItemHandlerModifiable;
        super.m_142466_(pTag);
        CompoundTag data = pTag.m_128469_("MachineData");
        MachineBlockEntity machineBlockEntity = this;
        if (machineBlockEntity instanceof ItemHandlerBlockEntity && (iItemHandlerModifiable = (itemHandlerBlockEntity = (ItemHandlerBlockEntity)((Object)machineBlockEntity)).getItemHandler()) instanceof ItemStackHandler) {
            handler = (ItemStackHandler)iItemHandlerModifiable;
            itemInventoryTag = data.m_128469_("item_inventory");
            handler.deserializeNBT((CompoundTag)itemInventoryTag);
        }
        if ((handler = this) instanceof FluidHandlerBlockEntity && (itemInventoryTag = (fluidHandlerBlockEntity = (FluidHandlerBlockEntity)((Object)handler)).getFluidHandler()) instanceof SerializableSingleFluidTank) {
            SerializableSingleFluidTank tank = (SerializableSingleFluidTank)itemInventoryTag;
            CompoundTag fluidInventoryTag = data.m_128469_("fluid_inventory");
            tank.deserializeNBT(fluidInventoryTag);
        }
        if (data.m_128441_("Data")) {
            this.readMachineData(data.m_128423_("Data"));
        }
    }

    public abstract boolean canProcess(ItemStack ... var1);

    @NotNull
    public abstract List<ItemStack> processItem(ItemStack ... var1);

    protected void mergeStack(int slot, ItemStack stack) {
        MachineBlockEntity machineBlockEntity = this;
        if (machineBlockEntity instanceof ItemHandlerBlockEntity) {
            ItemHandlerBlockEntity itemHandlerBlockEntity = (ItemHandlerBlockEntity)((Object)machineBlockEntity);
            IItemHandlerModifiable handlerModifiable = itemHandlerBlockEntity.getItemHandler();
            ItemStack previous = handlerModifiable.getStackInSlot(slot);
            if (previous.m_41619_()) {
                handlerModifiable.setStackInSlot(slot, stack);
            } else if (ItemStack.m_150942_((ItemStack)previous, (ItemStack)stack)) {
                previous.m_41764_(previous.m_41613_() + stack.m_41613_());
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_187482_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag data = pkt.m_131708_();
        this.m_142466_(data);
    }
}

