/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MachineItemStackHandler
extends ItemStackHandler {
    private final int[] inputs;
    private final int[] outputs;
    private Runnable changeListener = () -> {};

    public MachineItemStackHandler(int slots, int[] inputs, int[] outputs) {
        super(slots);
        this.inputs = inputs;
        this.outputs = outputs;
    }

    protected boolean isInputSlot(int slot) {
        for (int input : this.inputs) {
            if (input != slot) continue;
            return true;
        }
        return false;
    }

    protected boolean isOutputSlot(int slot) {
        for (int output : this.outputs) {
            if (output != slot) continue;
            return true;
        }
        return false;
    }

    public int[] getAllInputSlots() {
        return this.inputs;
    }

    public int[] getAllOutputSlots() {
        return this.outputs;
    }

    public void setChangeListener(Runnable listener) {
        this.changeListener = listener != null ? listener : () -> {};
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.changeListener.run();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isInputSlot(slot) && super.isItemValid(slot, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isInputSlot(slot) || !this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }
}

