/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.cleaner;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.cleaner.CleanerMenu;
import net.vit.jurassicreborn.common.blocks.inventory.CleanerItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.FluidHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.SerializableSingleFluidTank;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.recipes.FluidAndItemRecipeWrapper;
import net.vit.jurassicreborn.common.recipes.cleaner.CleaningRecipe;
import net.vit.jurassicreborn.common.util.api.CleanableItem;
import org.jetbrains.annotations.NotNull;

public class CleanerBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity,
FluidHandlerBlockEntity {
    public static final int SLOTS = 8;
    public static final int[] INPUTS = new int[]{0, 1};
    public static final int[] OUTPUTS = new int[]{2, 3, 4, 5, 6, 7};
    @Nullable
    CleaningRecipe currentRecipe;
    private boolean usingCleaningRecipe = true;
    private int progress = 0;
    protected final MachineItemStackHandler machineItemStackHandler = new CleanerItemHandler(8, INPUTS, OUTPUTS);
    protected final SerializableSingleFluidTank tank = new SerializableSingleFluidTank(2000, fluidStack -> fluidStack.getFluid() == Fluids.f_76193_);
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex == 0) {
                return CleanerBlockEntity.this.tank.getFluidAmount();
            }
            if (pIndex == 1) {
                return CleanerBlockEntity.this.getProgress();
            }
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex == 0) {
                CleanerBlockEntity.this.tank.getFluid().setAmount(pValue);
            } else if (pIndex == 1) {
                CleanerBlockEntity.this.progress = pValue;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public CleanerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CLEANING_STATION.get(), pos, state);
        Network.ENTITIES.add(this);
        this.machineItemStackHandler.setChangeListener(() -> {
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        });
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CleanerBlockEntity instance) {
        ItemStack input = instance.getItemHandler().getStackInSlot(0);
        CleanableItem cleanable = CleanableItem.getCleanableItem(input);
        if (instance.progress >= 200) {
            if (instance.currentRecipe != null) {
                instance.addItem(instance.currentRecipe.assemble(new FluidAndItemRecipeWrapper((IItemHandlerModifiable)instance.machineItemStackHandler, instance.tank)));
                instance.currentRecipe = null;
                input.m_41774_(1);
            } else if (cleanable != null) {
                instance.addItem(cleanable.getCleanedItem(input, world.m_213780_()));
                input.m_41774_(1);
            }
            instance.progress = 0;
        }
        if (instance.isCleaning()) {
            ++instance.progress;
            instance.tank.getFluid().setAmount(instance.tank.getFluidAmount() - 1);
        }
        boolean bl = instance.usingCleaningRecipe = cleanable == null;
        if (input.m_41619_()) {
            instance.progress = 0;
        }
        if (instance.currentRecipe == null && instance.usingCleaningRecipe) {
            for (CleaningRecipe recipe : world.m_7465_().m_44013_(CleaningRecipe.CLEANING)) {
                if (!recipe.matches(new FluidAndItemRecipeWrapper((IItemHandlerModifiable)instance.machineItemStackHandler, instance.tank), world) || !instance.hasSpace()) continue;
                instance.currentRecipe = recipe;
                instance.progress = 0;
                break;
            }
        }
        if (instance.tank.getFluidAmount() <= 0 && instance.machineItemStackHandler.getStackInSlot(1).m_150930_(Items.f_42447_)) {
            instance.tank.setFluid(new FluidStack((Fluid)Fluids.f_76193_, 1000));
            ItemStack emptyBucket = Items.f_42446_.m_7968_();
            if (instance.addItem(emptyBucket.m_41777_())) {
                instance.machineItemStackHandler.setStackInSlot(1, ItemStack.f_41583_);
            } else {
                instance.machineItemStackHandler.setStackInSlot(1, emptyBucket);
            }
        }
    }

    public boolean isCleaning() {
        ItemStack input = this.machineItemStackHandler.getStackInSlot(0);
        return CleanableItem.getCleanableItem(input) != null && this.hasSpace() && this.tank.getFluid().getAmount() > 0 || this.currentRecipe != null;
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public boolean hasSpace() {
        for (int i = 2; i < 8; ++i) {
            if (!this.machineItemStackHandler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean addItem(ItemStack stack) {
        for (int i = 2; i < 8; ++i) {
            if (!this.machineItemStackHandler.getStackInSlot(i).m_41619_()) continue;
            this.machineItemStackHandler.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new CleanerMenu(i, inventory, this.machineItemStackHandler, this.dataAccess);
    }

    @Override
    protected Component getDefaultName() {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents("block.JurassicReborn.cleaner_block_name"));
    }

    @Override
    public Tag getMachineData() {
        CompoundTag pTag = new CompoundTag();
        pTag.m_128405_("Progress", this.progress);
        return pTag;
    }

    @Override
    public void readMachineData(Tag machineData) {
        if (machineData instanceof CompoundTag) {
            CompoundTag pTag = (CompoundTag)machineData;
            this.progress = pTag.m_128451_("Progress");
        }
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        return null;
    }
}

