/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.incubator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.entities.incubator.IncubatorMenu;
import net.vit.jurassicreborn.common.blocks.inventory.IncubatorItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.DinosaurEggItem;
import net.vit.jurassicreborn.common.util.block.TemperatureControl;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class IncubatorBlockEntity
extends MachineBlockEntity
implements TemperatureControl,
IAnimatable,
MenuProvider,
ItemHandlerBlockEntity {
    public static final int[] INPUTS = new int[]{0, 1, 2, 3, 4};
    public static final int[] ENVIRONMENT = new int[]{5};
    private static final int[] HANDLER_INPUTS = IntStream.concat(Arrays.stream(INPUTS), Arrays.stream(ENVIRONMENT)).toArray();
    public static final int[] OUTPUTS = Arrays.copyOf(INPUTS, INPUTS.length);
    public static final int PROCESS_TIME = 4000;
    private int[] temperature = new int[5];
    private int[] eggIncubationTime = new int[5];
    private final IncubatorItemHandler machineItemStackHandler = new IncubatorItemHandler(6, HANDLER_INPUTS, OUTPUTS);
    private boolean menuOpen = false;
    private int currentProcess = 0;
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex < 5) {
                return IncubatorBlockEntity.this.temperature[pIndex];
            }
            if (pIndex < 10) {
                return IncubatorBlockEntity.this.eggIncubationTime[pIndex - 5];
            }
            if (pIndex < 13) {
                return this.blockPosToArr(IncubatorBlockEntity.this.m_58899_())[pIndex - 10];
            }
            return -1;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex < 5) {
                IncubatorBlockEntity.this.temperature[pIndex] = pValue;
            } else if (pIndex < 10) {
                IncubatorBlockEntity.this.eggIncubationTime[pIndex - 5] = pValue;
            }
        }

        protected int[] blockPosToArr(BlockPos pos) {
            return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
        }

        public int m_6499_() {
            return 13;
        }
    };
    protected static final AnimationBuilder INACTIVE = new AnimationBuilder().addAnimation("animation.incubator.inactive");
    protected static final AnimationBuilder TRANSITION_ACTIVE = new AnimationBuilder().addAnimation("animation.incubator.transition_active");
    protected static final AnimationBuilder TRANSITION_ACTIVE_LOOP = new AnimationBuilder().addAnimation("animation.incubator.transition_active", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder ACTIVE = new AnimationBuilder().addAnimation("animation.incubator.active");
    protected static final AnimationBuilder TRANSITION_INACTIVE = new AnimationBuilder().addAnimation("animation.incubator.transition_inactive");
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public IncubatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.INCUBATOR_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    public Tag getMachineData() {
        CompoundTag data = new CompoundTag();
        ListTag dataList = new ListTag();
        for (int i = 0; i < 5; ++i) {
            CompoundTag dataEntry = new CompoundTag();
            dataEntry.m_128405_("temperature", this.temperature[i]);
            dataEntry.m_128405_("incubationTime", this.eggIncubationTime[i]);
            dataList.add((Object)dataEntry);
        }
        data.m_128365_("SlotDataEntryList", (Tag)dataList);
        data.m_128379_("menuOpen", this.menuOpen);
        return data;
    }

    @Override
    public void readMachineData(Tag data) {
        CompoundTag machineData = (CompoundTag)data;
        ListTag dataList = machineData.m_128437_("SlotDataEntryList", 10);
        for (int i = 0; i < 5; ++i) {
            CompoundTag dataEntry = dataList.m_128728_(i);
            this.temperature[i] = dataEntry.m_128451_("temperature");
            this.eggIncubationTime[i] = dataEntry.m_128451_("incubationTime");
        }
        if (machineData.m_128441_("menuOpen")) {
            this.menuOpen = machineData.m_128471_("menuOpen");
        }
    }

    @Override
    public void setTemperature(int index, int value) {
        this.temperature[index] = value;
    }

    @Override
    public int getTemperature(int index) {
        return this.temperature[index];
    }

    @Override
    public int getTemperatureCount() {
        return 5;
    }

    public boolean isProcessing() {
        return Arrays.stream(this.eggIncubationTime).anyMatch(i -> i != 0);
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.incubator");
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        this.setMenuOpen(true);
        return new IncubatorMenu(pContainerId, pInventory, this.machineItemStackHandler, this.data);
    }

    public void setMenuOpen(boolean open) {
        this.menuOpen = open;
        if (this.f_58857_ != null) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isMenuOpen() {
        return this.menuOpen;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        if (this.canProcess(inputs[0]) && !this.f_58857_.f_46443_) {
            DinoDNA dna;
            ItemStack egg = inputs[0];
            DinosaurEggItem dinoEgg = (DinosaurEggItem)egg.m_41720_();
            ItemStack incubatedEgg = new ItemStack((ItemLike)ModItems.hatchedDinoEggs.get(dinoEgg.getDino()).get(), 1);
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("Gender", this.temperature[this.currentProcess] > 50);
            if (egg.m_41783_() != null && (dna = DinoDNA.readFromNBT(egg.m_41783_())) != null) {
                dna.writeToNBT(compound);
            }
            incubatedEgg.m_41751_(compound);
            this.decreaseStackSize(ENVIRONMENT[0]);
            return List.of(incubatedEgg);
        }
        return List.of(ItemStack.f_41583_);
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        Item item;
        ItemStack environment = this.machineItemStackHandler.getStackInSlot(ENVIRONMENT[0]);
        boolean hasEnvironment = false;
        if (!environment.m_41619_() && IncubatorItemHandler.isEnvironment(5, item = environment.m_41720_())) {
            hasEnvironment = true;
        }
        return hasEnvironment && !inputs[0].m_41619_() && inputs[0].m_41613_() > 0 && inputs[0].m_41720_() instanceof DinosaurEggItem;
    }

    public static void tick(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull IncubatorBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        for (int input = 0; input < INPUTS.length; ++input) {
            pBlockEntity.currentProcess = input;
            int time = pBlockEntity.eggIncubationTime[input];
            int egg = INPUTS[input];
            if (!pBlockEntity.canProcess(pBlockEntity.machineItemStackHandler.getStackInSlot(egg))) {
                pBlockEntity.eggIncubationTime[input] = 0;
                continue;
            }
            int n = input;
            pBlockEntity.eggIncubationTime[n] = pBlockEntity.eggIncubationTime[n] + 1;
            if (time < 4000) continue;
            ItemStack output = pBlockEntity.processItem(pBlockEntity.machineItemStackHandler.getStackInSlot(egg)).get(0);
            if (output.m_41619_()) {
                pBlockEntity.eggIncubationTime[input] = 0;
                continue;
            }
            pBlockEntity.machineItemStackHandler.setStackInSlot(egg, output);
            pBlockEntity.eggIncubationTime[input] = 0;
        }
    }

    private void decreaseStackSize(int slot) {
        ItemStack stack = this.machineItemStackHandler.getStackInSlot(slot);
        stack.m_41774_(1);
        if (stack.m_41613_() <= 0) {
            this.machineItemStackHandler.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 16.0f, this::controller));
    }

    protected <E extends IncubatorBlockEntity> PlayState controller(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        if (controller.getCurrentAnimation() == null) {
            controller.setAnimation(INACTIVE);
            return PlayState.CONTINUE;
        }
        if (this.menuOpen && controller.getCurrentAnimation().animationName.equals("animation.incubator.inactive")) {
            controller.setAnimation(TRANSITION_ACTIVE.addAnimation("animation.incubator.active"));
        } else if (!this.menuOpen && controller.getCurrentAnimation().animationName.equals("animation.incubator.active")) {
            controller.setAnimation(TRANSITION_INACTIVE.addAnimation("animation.incubator.inactive"));
        } else if (!this.menuOpen) {
            controller.setAnimation(INACTIVE);
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

