/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.skeletonassembly;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.Fossils.FossilItem;
import net.vit.jurassicreborn.common.items.ModItems;

public class SkeletonRecipeHelper {
    private static final int GRID_W = 5;
    private static final int GRID_H = 5;

    public static Result tryMatch(IItemHandler items) {
        AssemblyData data = null;
        int minX = 5;
        int minY = 5;
        int maxX = -1;
        int maxY = -1;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack = items.getStackInSlot(x + y * 5);
                AssemblyData d = SkeletonRecipeHelper.assemblyOf(stack);
                if (d == null) continue;
                if (data != null && !data.equals(d)) {
                    return new Result(false, ItemStack.f_41583_, new int[4]);
                }
                data = d;
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
            }
        }
        if (data == null || data.dino.getRecipe() == null) {
            return new Result(false, ItemStack.f_41583_, new int[4]);
        }
        String[][] recipe = data.dino.getRecipe();
        if (maxX - minX + 1 != recipe[0].length || maxY - minY + 1 != recipe.length) {
            return new Result(false, ItemStack.f_41583_, new int[4]);
        }
        for (int y = 0; y < recipe.length; ++y) {
            for (int x = 0; x < recipe[0].length; ++x) {
                ItemStack in = items.getStackInSlot(x + minX + (y + minY) * 5);
                if (recipe[y][x].equals(SkeletonRecipeHelper.boneType(in))) continue;
                return new Result(false, ItemStack.f_41583_, new int[4]);
            }
        }
        int[] bounds = new int[]{minX, minY, maxX, maxY};
        return new Result(true, data.makeResult(), bounds);
    }

    private static AssemblyData assemblyOf(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem fi = (FossilItem)item;
            return new AssemblyData(fi.getDinosaur(stack), fi.isFresh());
        }
        return null;
    }

    private static String boneType(ItemStack stack) {
        String string;
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem fi = (FossilItem)item;
            string = fi.getBoneType();
        } else {
            string = "";
        }
        return string;
    }

    private record AssemblyData(Dinosaur dino, boolean fresh) {
        ItemStack makeResult() {
            if (this.fresh) {
                return new ItemStack((ItemLike)ModItems.FRESH_SKELETONS.get(this.dino).get());
            }
            return new ItemStack((ItemLike)ModItems.FOSSIL_SKELETONS.get(this.dino).get());
        }
    }

    public record Result(boolean success, ItemStack output, int[] bounds) {
    }
}

