/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.AmphibianDinosaurEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AchillobatorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlligatorGarEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlvarezsaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ArsinoitheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BeelzebufoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CarnotaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CeratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChasmosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChilesaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CoelurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CorythosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CrassigyrinusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DimorphodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplocaulusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DodoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ElasmotheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GallimimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GiganotosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GuanlongEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HyaenodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.KairukuEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeaellynasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MaiasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MammothEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegapiranhaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegatheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MetriacanthosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MussaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.NigersaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OrnithomimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OthnieliaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OviraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PachycephalosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParasaurolophusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PostosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProceratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProtoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.RugopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SegisaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SinoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SmilodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SpinosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.StegosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.StyracosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TitanisEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TriceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TroodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TyrannosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorBlueEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorCharlieEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorDeltaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEchoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.ai.HurtByTargetGoal;
import net.vit.jurassicreborn.common.entities.ai.LeapingMeleeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.RaptorLeapEntityAI;

public class SpinoraptorEntity
extends AmphibianDinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SpinoraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Class[] targets = new Class[]{CompsognathusEntity.class, MammothEntity.class, VelociraptorEntity.class, VelociraptorBlueEntity.class, VelociraptorCharlieEntity.class, VelociraptorDeltaEntity.class, VelociraptorEchoEntity.class, MegatheriumEntity.class, ElasmotheriumEntity.class, ArsinoitheriumEntity.class, Player.class, DilophosaurusEntity.class, DimorphodonEntity.class, DodoEntity.class, LeaellynasauraEntity.class, HypsilophodonEntity.class, StegosaurusEntity.class, ProtoceratopsEntity.class, OthnieliaEntity.class, MicroceratusEntity.class};

    public SpinoraptorEntity(Level world, EntityType<SpinoraptorEntity> type) {
        super(world, (EntityType)type, DinosaurHandler.SPINORAPTOR);
        this.setVariant(this.m_217043_().m_188503_(5));
        this.target(AchillobatorEntity.class, MetriacanthosaurusEntity.class, TitanisEntity.class, SmilodonEntity.class, MegatheriumEntity.class, ArsinoitheriumEntity.class, SinoceratopsEntity.class, AlligatorGarEntity.class, AlvarezsaurusEntity.class, BeelzebufoEntity.class, VelociraptorBlueEntity.class, CarnotaurusEntity.class, CeratosaurusEntity.class, VelociraptorCharlieEntity.class, ChasmosaurusEntity.class, NigersaurusEntity.class, ChilesaurusEntity.class, KairukuEntity.class, CoelurusEntity.class, CompsognathusEntity.class, CorythosaurusEntity.class, MaiasauraEntity.class, CrassigyrinusEntity.class, VelociraptorDeltaEntity.class, DilophosaurusEntity.class, DimorphodonEntity.class, DiplocaulusEntity.class, DodoEntity.class, VelociraptorEchoEntity.class, GallimimusEntity.class, GuanlongEntity.class, HyaenodonEntity.class, HypsilophodonEntity.class, LeaellynasauraEntity.class, LeptictidiumEntity.class, MegapiranhaEntity.class, MicroceratusEntity.class, MicroraptorEntity.class, MussaurusEntity.class, OrnithomimusEntity.class, OthnieliaEntity.class, OviraptorEntity.class, PachycephalosaurusEntity.class, ParasaurolophusEntity.class, PostosuchusEntity.class, DeinosuchusEntity.class, ProceratosaurusEntity.class, ProtoceratopsEntity.class, RugopsEntity.class, SegisaurusEntity.class, StyracosaurusEntity.class, TriceratopsEntity.class, TroodonEntity.class, VelociraptorEntity.class, Player.class, Animal.class, Villager.class, Goat.class);
        this.addTask(0, (Goal)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.addTask(1, new RaptorLeapEntityAI(this));
        this.target(targets);
        for (Class entity : targets) {
            this.addTask(0, (Goal)new NearestAttackableTargetGoal((Mob)this, entity, true, false));
        }
        this.addTask(1, (Goal)new HurtByTargetGoal(this, Player.class, TyrannosaurusEntity.class, GiganotosaurusEntity.class, SpinosaurusEntity.class));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.SPINORAPTOR_LIVING;
            }
            case DYING: {
                return SoundHandler.SPINORAPTOR_DEATH;
            }
            case INJURED: {
                return SoundHandler.SPINORAPTOR_HURT;
            }
            case CALLING: {
                return SoundHandler.SPINORAPTOR_CALL;
            }
            case ROARING: {
                return SoundHandler.SPINORAPTOR_CALL;
            }
            case BEGGING: {
                return SoundHandler.SPINOSAURUS_THREAT;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.SPINORAPTOR_BREATHING;
    }

    public int m_5639_(float distance, float damageMultiplier) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            return super.m_5639_(distance, damageMultiplier);
        }
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("black");
            }
            case 1: {
                return this.texture("green");
            }
            case 2: {
                return this.texture("grey");
            }
            case 3: {
                return this.texture("orange");
            }
            case 4: 
        }
        return this.texture("vivid");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }
}

