/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DreadnoughtusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DreadnoughtusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.22f;

    public DreadnoughtusDinosaur() {
        this.setName("Dreadnoughtus");
        this.setScientificName("Dreadnoughtus schrani");
        this.setFamily("Titanosauria");
        this.setLocation("Argentina");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(DreadnoughtusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(5796213, 5132368);
        this.setEggColorFemale(8613195, 11706491);
        this.setHealth(10.0, 160.0);
        this.setSpeed(0.16999999880790712, 0.22f);
        this.setStrength(5.0, 15.0);
        this.setMaximumAge(this.fromDays(85));
        this.setEyeHeight(0.4f, 3.8f);
        this.setSizeX(0.4f, 6.1f);
        this.setSizeY(0.5f, 6.6f);
        this.setStorage(54);
        this.setPaleoPadScale(5.0f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.35f, 0.1f);
        this.setOffset(0.0f, 0.0f, 0.0f);
        this.setAttackBias(1200.0);
        this.setMaxHerdSize(4);
        this.setBreeding(false, 4, 8, 70, true, false);
        String[][] recipe = new String[][]{{"", "", "", "", "skull"}, {"", "", "", "neck_vertebrae", "tooth"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "hind_leg_bones", "hind_leg_bones", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_215816_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

