/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SmilodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class SmilodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public SmilodonDinosaur() {
        this.setName("Smilodon");
        this.setScientificName("Smilodon populator");
        this.setFamily("Felidae");
        this.setLocation("North America");
        this.setDinosaurClass(SmilodonEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(11302432, 1642755);
        this.setEggColorFemale(12750396, 5124616);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setAttackSpeed(1.9);
        this.setHealth(6.0, 30.0);
        this.setStrength(2.0, 10.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 1.7f);
        this.setSizeX(0.5f, 1.0f);
        this.setSizeY(0.5f, 1.8f);
        this.setStorage(20);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBones("skull", "tail_vertebrae", "front_leg_bones", "ribcage", "hind_leg_bones", "neck_vertebrae", "pelvis", "shoulder", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(0.55f, 0.1f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setMammal(true);
        this.setMaxHerdSize(40);
        this.setAttackBias(600.0);
        this.setCanClimb(true);
        this.setBreeding(true, 2, 5, 50, false, true);
        this.setJumpHeight(3);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "", "front_leg_bones", "shoulder", "tooth"}};
        this.setRecipe(recipe);
        this.doSkeletonCheck();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY, Tags.Biomes.IS_COLD};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }

    protected void doSkeletonCheck() {
        this.enableSkeleton();
    }
}

