/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.metabolism;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlock;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.FlyingDinosaurEntity;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class FeederEntityAI
extends Goal {
    private final DinosaurEntity dino;
    private Path path;
    private BlockPos feederPos;
    private Vec3 feederTarget;
    private int ticksTrying;
    private boolean waitingForFood;
    private int foodWaitTicks;
    private ItemEntity targetFoodItem;

    public FeederEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        boolean canDirectMove;
        Path p;
        FeederBlockEntity feeder;
        int intervalMask;
        if (this.dino == null || this.dino.m_213877_() || this.dino.isCarcass() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (!this.dino.f_19853_.m_46469_().m_46207_(GameRuleHandler.DINO_METABOLISM)) {
            return false;
        }
        int n = intervalMask = this.dino.isMarineCreature() ? 7 : 15;
        if ((this.dino.f_19797_ & intervalMask) != 0) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        BlockPos found = this.dino.getClosestFeeder();
        if (found == null) {
            return false;
        }
        Level level = this.dino.f_19853_;
        if (level == null || !level.m_46805_(found)) {
            return false;
        }
        BlockState state = level.m_8055_(found);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            return false;
        }
        BlockEntity be = level.m_7702_(found);
        if (!(be instanceof FeederBlockEntity) || !(feeder = (FeederBlockEntity)be).isStockedFor(this.dino)) {
            return false;
        }
        Vec3 target = this.computeTarget(found, state);
        try {
            p = this.dino.m_21573_().m_7864_(new BlockPos((int)target.f_82479_, (int)target.f_82480_, (int)target.f_82481_), 0);
        }
        catch (Throwable t) {
            p = null;
        }
        boolean bl = canDirectMove = this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity;
        if (p == null && !canDirectMove) {
            return false;
        }
        this.feederPos = found.m_7949_();
        this.path = p;
        this.feederTarget = target;
        this.ticksTrying = 0;
        this.waitingForFood = false;
        this.foodWaitTicks = 0;
        this.targetFoodItem = null;
        return true;
    }

    public void m_8056_() {
        if (this.path != null) {
            this.dino.m_21573_().m_26536_(this.path, 1.0);
        } else if (this.feederTarget != null) {
            if (this.shouldTakeOffForTarget()) {
                ((FlyingDinosaurEntity)this.dino).startTakeOff();
            }
            this.dino.m_21573_().m_26519_(this.feederTarget.f_82479_, this.feederTarget.f_82480_, this.feederTarget.f_82481_, 1.0);
        }
    }

    public boolean m_8045_() {
        boolean directMove;
        if (this.dino == null || this.feederPos == null) {
            return false;
        }
        if (this.dino.isCarcass() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        if (this.waitingForFood && this.foodWaitTicks < 120) {
            return true;
        }
        if (this.targetFoodItem != null && !this.targetFoodItem.m_213877_()) {
            return true;
        }
        BlockState state = this.dino.f_19853_.m_8055_(this.feederPos);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            return false;
        }
        this.feederTarget = this.computeTarget(this.feederPos, state);
        boolean bl = directMove = this.path == null && (this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity);
        if (directMove && this.feederTarget != null) {
            double reach;
            double dist = this.dino.m_20182_().m_82554_(this.feederTarget);
            return dist > (reach = Math.max(2.0, (double)this.dino.m_20205_() * 3.0)) && this.ticksTrying < 300;
        }
        return !this.dino.m_21573_().m_26571_() && this.ticksTrying < 300;
    }

    public void m_8037_() {
        if (this.feederPos == null) {
            return;
        }
        if (this.targetFoodItem != null && !this.targetFoodItem.m_213877_()) {
            if (this.tryEatSpecificItem(this.targetFoodItem)) {
                this.m_8041_();
                return;
            }
            this.dino.m_21573_().m_26519_(this.targetFoodItem.m_20185_(), this.targetFoodItem.m_20186_(), this.targetFoodItem.m_20189_(), 1.2);
            ++this.ticksTrying;
            if (this.ticksTrying > 300) {
                this.m_8041_();
            }
            return;
        }
        if (this.waitingForFood) {
            ++this.foodWaitTicks;
            ItemEntity foundFood = this.scanForNearbyFood();
            if (foundFood != null) {
                this.targetFoodItem = foundFood;
                this.waitingForFood = false;
                return;
            }
            if (this.foodWaitTicks >= 120) {
                this.m_8041_();
                return;
            }
            return;
        }
        BlockState state = this.dino.f_19853_.m_8055_(this.feederPos);
        if (state.m_60734_() != ModBlocks.FEEDER.get()) {
            this.m_8041_();
            return;
        }
        this.feederTarget = this.computeTarget(this.feederPos, state);
        if (++this.ticksTrying % 40 == 0 && (this.path == null || this.dino.m_21573_().m_26571_())) {
            BlockPos targetPos = new BlockPos((int)this.feederTarget.f_82479_, (int)this.feederTarget.f_82480_, (int)this.feederTarget.f_82481_);
            Path retry = this.dino.m_21573_().m_7864_(targetPos, 0);
            if (retry != null) {
                this.path = retry;
                this.dino.m_21573_().m_26536_(retry, 1.0);
            } else if (this.dino.isMarineCreature() || this.dino instanceof FlyingDinosaurEntity) {
                if (this.shouldTakeOffForTarget()) {
                    ((FlyingDinosaurEntity)this.dino).startTakeOff();
                }
                this.dino.m_21573_().m_26519_(this.feederTarget.f_82479_, this.feederTarget.f_82480_, this.feederTarget.f_82481_, 1.0);
            }
        }
        if (!this.dino.f_19853_.f_46443_) {
            BlockEntity be;
            double reach;
            Vec3 target = this.feederTarget != null ? this.feederTarget : Vec3.m_82512_((Vec3i)this.feederPos);
            double dist = this.dino.m_20182_().m_82554_(target);
            if (dist <= (reach = Math.max(2.0, (double)this.dino.m_20205_() * 3.0)) && (be = this.dino.f_19853_.m_7702_(this.feederPos)) instanceof FeederBlockEntity) {
                FeederBlockEntity feeder = (FeederBlockEntity)be;
                DinosaurEntity currentFeeding = feeder.getFeeding();
                if (currentFeeding == null || currentFeeding == this.dino) {
                    feeder.setOpen(true);
                    feeder.setFeeding(this.dino);
                    this.waitingForFood = true;
                    this.foodWaitTicks = 0;
                    this.dino.m_21573_().m_26573_();
                } else if (this.ticksTrying > 200) {
                    this.m_8041_();
                }
            }
        }
    }

    public void m_8041_() {
        if (this.dino != null) {
            this.dino.m_21573_().m_26573_();
        }
        this.path = null;
        this.feederPos = null;
        this.feederTarget = null;
        this.ticksTrying = 0;
        this.waitingForFood = false;
        this.foodWaitTicks = 0;
        this.targetFoodItem = null;
    }

    private ItemEntity scanForNearbyFood() {
        if (this.dino.f_19853_.f_46443_ || this.feederPos == null) {
            return null;
        }
        double searchRadius = this.dino.isMarineCreature() ? 8.0 : 5.0;
        AABB searchBox = new AABB(this.feederPos).m_82400_(searchRadius);
        List items = this.dino.f_19853_.m_45976_(ItemEntity.class, searchBox);
        ItemEntity closest = null;
        double closestDist = Double.MAX_VALUE;
        for (ItemEntity itemEntity : items) {
            double dist;
            if (itemEntity.m_213877_() || itemEntity.m_32055_().m_41619_() || !FoodHelper.isEdible(this.dino, this.dino.getDinosaur().getDiet(), itemEntity.m_32055_().m_41720_()) || !((dist = this.dino.m_20182_().m_82554_(itemEntity.m_20182_())) < closestDist)) continue;
            closestDist = dist;
            closest = itemEntity;
        }
        return closest;
    }

    private boolean tryEatSpecificItem(ItemEntity itemEntity) {
        double eatReach;
        if (this.dino.f_19853_.f_46443_ || itemEntity == null || itemEntity.m_213877_()) {
            return false;
        }
        double distToItem = this.dino.m_20182_().m_82554_(itemEntity.m_20182_());
        if (distToItem <= (eatReach = Math.max(2.0, (double)this.dino.m_20205_() * 2.0)) && FoodHelper.isEdible(this.dino, this.dino.getDinosaur().getDiet(), itemEntity.m_32055_().m_41720_())) {
            int foodValue = FoodHelper.getHealAmount(itemEntity.m_32055_().m_41720_());
            this.dino.getMetabolism().eat(foodValue);
            FoodHelper.applyEatEffects(this.dino, itemEntity.m_32055_().m_41720_());
            itemEntity.m_32055_().m_41774_(1);
            if (itemEntity.m_32055_().m_41619_()) {
                itemEntity.m_146870_();
            }
            return true;
        }
        return false;
    }

    private Vec3 computeTarget(BlockPos pos, BlockState state) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        if (!state.m_61138_((Property)FeederBlock.FACING)) {
            return center;
        }
        Direction facing = (Direction)state.m_61143_((Property)FeederBlock.FACING);
        double forward = 1.2;
        double vertical = 0.0;
        if (facing.m_122434_().m_122479_()) {
            if (this.dino.isMarineCreature()) {
                vertical = 0.1;
                forward = 1.5;
            } else {
                vertical = 0.3;
            }
        } else if (facing == Direction.UP) {
            vertical = 1.0;
        } else if (facing == Direction.DOWN) {
            vertical = -0.5;
        }
        return center.m_82520_((double)facing.m_122429_() * forward, (double)facing.m_122430_() * forward + vertical, (double)facing.m_122431_() * forward);
    }

    private boolean shouldTakeOffForTarget() {
        if (!(this.dino instanceof FlyingDinosaurEntity) || this.feederTarget == null) {
            return false;
        }
        boolean needsAltitude = this.feederTarget.f_82480_ - this.dino.m_20186_() > 0.75;
        return needsAltitude || this.path == null;
    }
}

