/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.animal;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.render.entity.animation.PoseHandler;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.SmartBodyHelper;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.ai.WanderAroundWaterAI;
import net.vit.jurassicreborn.common.entities.animal.SharkEntity;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends Animal
implements Animatable,
IEntityAdditionalSpawnData {
    private static final PoseHandler<CrabEntity> CRAB_POSE_HANDLER = new PoseHandler("crab", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    public static final EntityDataAccessor<Boolean> CRAB_IS_RUNNING = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private boolean alternative;

    public CrabEntity(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.f_19793_ = 1.0f;
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(10, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(10, (Goal)new WanderAroundWaterAI(this, 1.0, 5, 2));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, SharkEntity.class, 9.0f, 1.0, (double)1.45f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        if (this.m_6060_()) {
            itemsToDrop.add(new ItemStack((ItemLike)ModItems.CRAB_MEAT_COOKED.get(), this.m_217043_().m_188503_(2) + 1));
        } else {
            itemsToDrop.add(new ItemStack((ItemLike)ModItems.CRAB_MEAT_RAW.get(), this.m_217043_().m_188503_(2) + 1));
        }
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        for (ItemStack stack : itemsToDrop) {
            this.m_19983_(stack);
        }
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public boolean isMoving() {
        double powx = this.m_20184_().f_82479_;
        powx *= powx;
        double powz = this.m_20184_().f_82481_;
        powz *= powz;
        double powy = this.m_20184_().f_82480_;
        return powx + powz + (powy *= powy) > (double)0.001f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(EntityAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(CRAB_IS_RUNNING, (Object)((double)this.m_6113_() > this.m_21133_(Attributes.f_22279_) ? 1 : 0));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CRAB_IS_RUNNING, (Object)false);
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @Override
    public boolean inWater() {
        return this.m_20069_();
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(CRAB_IS_RUNNING);
    }

    @Override
    public boolean inLava() {
        return this.m_20077_();
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return growthStage.equals((Object)GrowthStage.ADULT);
    }

    @Override
    public boolean isMarineCreature() {
        return true;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return GrowthStage.ADULT;
    }

    public PoseHandler<CrabEntity> getPoseHandler() {
        return CRAB_POSE_HANDLER;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return new CrabEntity((EntityType<? extends Animal>)((EntityType)ModEntities.CRAB.get()), (Level)p_146743_);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (this.m_6084_() && !this.m_20069_()) {
            this.m_20301_(--i);
        } else {
            this.m_20301_(300);
        }
    }

    public void m_19920_(float friction, Vec3 rel) {
        double strafe = rel.f_82479_;
        double up = rel.f_82480_;
        double forward = rel.f_82481_;
        float f = (float)(strafe * strafe + up * up + forward * forward);
        if (f >= 1.0E-4f) {
            if ((f = Mth.m_14116_((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double deltaMotionX = (strafe *= (double)f) * (double)f2 - (forward *= (double)f) * (double)f1;
            double deltaMotionY = up *= (double)f;
            double deltaMotionZ = forward * (double)f2 + strafe * (double)f1;
            Vec3 deltaMotion = new Vec3(deltaMotionX, deltaMotionY, deltaMotionZ);
            this.m_20256_(this.m_20184_().m_82549_(deltaMotion));
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public Type getCrabType() {
        return this.alternative ? Type.ALTERNATIVE : Type.CRAB;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static boolean checkCrabSpawnRules(EntityType<CrabEntity> type, LevelAccessor pLevel, MobSpawnType reason, BlockPos pPos, RandomSource random) {
        return RebornConfig.spawnCrabs && pPos.m_123342_() < pLevel.m_5736_() + 4 && CrabEntity.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    public static enum Type {
        CRAB,
        ALTERNATIVE;

    }
}

