/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.genetics;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.vit.jurassicreborn.common.genetics.DNA;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.LangUtil;

public class PlantDNA
extends DNA {
    private ResourceLocation plant;

    public PlantDNA(ResourceLocation plant, int quality) {
        super(plant.toString(), quality);
        this.plant = plant;
    }

    public static PlantDNA fromStack(ItemStack stack) {
        return PlantDNA.readFromNBT(stack.m_41783_());
    }

    public static PlantDNA readFromNBT(CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        if (!tag.m_128441_("DNA")) {
            return null;
        }
        CompoundTag nbt = tag.m_128469_("DNA");
        return new PlantDNA(new ResourceLocation(nbt.m_128461_("Plant")), nbt.m_128451_("DNAQuality"));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("DNAQuality", this.quality);
        nbt.m_128359_("Plant", this.plant.toString());
        nbt.m_128359_("StorageId", "PlantDNA");
        tag.m_128365_("DNA", (Tag)nbt);
    }

    public ResourceLocation getPlant() {
        return this.plant;
    }

    @Override
    public void addInformation(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"lore.plant").getString().replace("{plant}", PlantHandler.getPlantById(this.plant).getName())).m_130940_(ChatFormatting.DARK_AQUA));
        ChatFormatting formatting = this.quality > 75 ? ChatFormatting.GREEN : (this.quality > 50 ? ChatFormatting.YELLOW : (this.quality > 25 ? ChatFormatting.GOLD : (this.quality == -1 ? ChatFormatting.AQUA : ChatFormatting.RED)));
        String qualityString = Component.m_237115_((String)"lore.dna_quality").getString();
        Component quality = LangUtil.getFormattedQuality(this.quality);
        tooltip.add((Component)Component.m_237113_((String)qualityString.formatted(quality.getString(), "%")).m_130940_(formatting));
    }

    public Plant getRealPlant() {
        return PlantHandler.getPlantById(this.plant);
    }
}

