/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.ActionFigureBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.misc.ActionFigureItem;
import net.vit.jurassicreborn.common.items.misc.FossilSkeletonItem;
import net.vit.jurassicreborn.common.items.misc.SkeletonPoseHelper;
import net.vit.jurassicreborn.common.util.LangUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreshSkeletonItem
extends Item {
    private static final String TAG_FOSSILE = "IsFossile";
    private static final String TAG_VARIANT = "Variant";
    private final Dinosaur dino;
    private final boolean isSkeleton = true;
    private final boolean fresh = true;

    public FreshSkeletonItem(Item.Properties properties, Dinosaur dino) {
        super(properties);
        this.dino = dino;
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_FOSSILE, false);
        tag.m_128344_(TAG_VARIANT, (byte)0);
        stack.m_41751_(tag);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        IClientItemExtensions prop = new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return JurassicClient.displayBlockRendererWithoutLevel;
            }
        };
        consumer.accept(prop);
    }

    public boolean isSkeleton() {
        Objects.requireNonNull(this);
        return true;
    }

    public boolean isSkeleton(ItemStack stack) {
        if (stack.m_41720_() == this) {
            return this.isSkeleton();
        }
        Item item = stack.m_41720_();
        if (item instanceof FreshSkeletonItem) {
            FreshSkeletonItem fi = (FreshSkeletonItem)item;
            return fi.isSkeleton(stack);
        }
        item = stack.m_41720_();
        if (item instanceof FossilSkeletonItem) {
            FossilSkeletonItem fi = (FossilSkeletonItem)item;
            return fi.isSkeleton(stack);
        }
        item = stack.m_41720_();
        if (item instanceof ActionFigureItem) {
            ActionFigureItem afi = (ActionFigureItem)item;
            return afi.isSkeleton(stack);
        }
        return false;
    }

    public Dinosaur getDinosaur() {
        return this.dino;
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        if (stack.m_41720_() == this) {
            return this.getDinosaur();
        }
        Item item = stack.m_41720_();
        if (item instanceof FreshSkeletonItem) {
            FreshSkeletonItem fi = (FreshSkeletonItem)item;
            return fi.getDinosaur();
        }
        item = stack.m_41720_();
        if (item instanceof FossilSkeletonItem) {
            FossilSkeletonItem fi = (FossilSkeletonItem)item;
            return fi.getDinosaur();
        }
        item = stack.m_41720_();
        if (item instanceof ActionFigureItem) {
            ActionFigureItem afi = (ActionFigureItem)item;
            return afi.getDinosaur();
        }
        return Dinosaur.EMPTY;
    }

    public int getGender(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Gender")) {
            return this.getGender(tag.m_128461_("Gender"));
        }
        tag.m_128359_("Gender", "random");
        stack.m_41751_(tag);
        return 0;
    }

    public int getGender(String gender) {
        if (gender.equals("random")) {
            return 0;
        }
        if (gender.equals("male")) {
            return 1;
        }
        if (gender.equals("female")) {
            return 2;
        }
        return 0;
    }

    public String getGender(int gender) {
        if (gender == 0) {
            return "random";
        }
        if (gender == 1) {
            return "male";
        }
        if (gender == 2) {
            return "female";
        }
        return "";
    }

    public int changeGender(ItemStack stack) {
        int gender = this.getGender(stack);
        int newGender = (gender + 1) % 3;
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128359_("Gender", this.getGender(newGender));
        stack.m_41751_(stackTag);
        return newGender;
    }

    public boolean isFresh() {
        Objects.requireNonNull(this);
        return true;
    }

    public boolean isFresh(ItemStack stack) {
        return !this.isFossile(stack);
    }

    public boolean isFossile(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_FOSSILE)) {
            tag.m_128379_(TAG_FOSSILE, false);
            stack.m_41751_(tag);
        }
        return tag.m_128471_(TAG_FOSSILE);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return LangUtil.replaceWithDinoName(this.getDinosaur(stack), "item.JurassicReborn.skeleton.fresh");
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"lore.change_pose").m_130940_(ChatFormatting.BLUE));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        int pose = this.changePose(stack);
        if (level.f_46443_) {
            List<String> poses = SkeletonPoseHelper.getPoseNames(this.getDinosaur(stack));
            String name = poses.get(pose);
            player.m_5661_((Component)Component.m_237110_((String)"skeleton.posechange", (Object[])new Object[]{name}), false);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int getPose(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_VARIANT)) {
            tag.m_128344_(TAG_VARIANT, (byte)0);
            stack.m_41751_(tag);
        }
        return tag.m_128445_(TAG_VARIANT);
    }

    public int changePose(ItemStack stack) {
        List<String> poses = SkeletonPoseHelper.getPoseNames(this.getDinosaur(stack));
        int pose = this.getPose(stack);
        int newPose = (pose + 1) % poses.size();
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TAG_VARIANT, (byte)newPose);
        stack.m_41751_(tag);
        return newPose;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        Block block = (Block)ModBlocks.DISPLAY_BLOCK.get();
        BlockState state = block.m_49966_();
        if (!this.canPlace(new BlockPlaceContext(context), state)) {
            return InteractionResult.FAIL;
        }
        BlockState state1 = block.m_5573_(new BlockPlaceContext(context));
        if (state1 == null) {
            return InteractionResult.FAIL;
        }
        world.m_7731_(pos, state1, 3);
        block.m_6402_(world, pos, state1, (LivingEntity)context.m_43723_(), stack);
        int gender = this.getGender(stack);
        ActionFigureBlockEntity afbe = FreshSkeletonItem.getPlacedBlockEntity(world, pos);
        if (afbe == null) {
            world.m_7471_(pos, false);
            return InteractionResult.FAIL;
        }
        afbe.setVariant((byte)this.getPose(stack));
        afbe.setDinosaur(this.getDinosaur(stack), gender > 0 ? gender == 1 : world.m_213780_().m_188499_(), this.isSkeleton(stack), this.isFossile(stack));
        afbe.setRot(180 - (int)Objects.requireNonNull(context.m_43723_()).m_6080_());
        world.m_46672_(pos, block);
        afbe.m_6596_();
        if (!context.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private static ActionFigureBlockEntity getPlacedBlockEntity(Level world, BlockPos pos) {
        ServerLevel serverLevel;
        BlockEntity created;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ActionFigureBlockEntity) {
            ActionFigureBlockEntity actionFigureBlockEntity = (ActionFigureBlockEntity)blockEntity;
            return actionFigureBlockEntity;
        }
        if (world instanceof ServerLevel && (created = (serverLevel = (ServerLevel)world).m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE)) instanceof ActionFigureBlockEntity) {
            ActionFigureBlockEntity actionFigureBlockEntity = (ActionFigureBlockEntity)created;
            return actionFigureBlockEntity;
        }
        return null;
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_220152_(category)) {
            ItemStack defaultStack = this.m_7968_();
            CompoundTag tag = defaultStack.m_41784_();
            tag.m_128359_("Gender", "random");
            defaultStack.m_41751_(tag);
            items.add((Object)defaultStack);
        }
    }
}

