/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;

public class SkeletonPoseHelper {
    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> getPoseNames(Dinosaur dino) {
        String name = dino.getName().toLowerCase(Locale.ROOT).replace(' ', '_');
        String path = "/assets/jurassicreborn/models/entities/" + name + "/skeleton/" + name + "_skeleton.json";
        try (InputStream in2222 = SkeletonPoseHelper.class.getResourceAsStream(path);){
            if (in2222 != null) {
                JsonObject root = JsonParser.parseReader((Reader)new InputStreamReader(in2222)).getAsJsonObject();
                JsonObject poses = root.getAsJsonObject("poses");
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                if (poses != null) {
                    for (Map.Entry entry : poses.entrySet()) {
                        JsonArray arr = ((JsonElement)entry.getValue()).getAsJsonArray();
                        for (JsonElement el : arr) {
                            JsonObject poseObj = el.getAsJsonObject();
                            String poseFile = poseObj.get("pose").getAsString();
                            int idx = poseFile.lastIndexOf(95);
                            String poseName = idx >= 0 ? poseFile.substring(idx + 1) : poseFile;
                            names.add(poseName);
                        }
                    }
                }
                if (!names.isEmpty()) {
                    ArrayList arrayList = new ArrayList(names);
                    return arrayList;
                }
            }
        }
        catch (Exception in2222) {
            // empty catch block
        }
        ArrayList<String> fallback = new ArrayList<String>();
        fallback.add("idle");
        return fallback;
    }

    public static List<TabulaModelContainer> getPoseModels(Dinosaur dino) {
        String name = dino.getName().toLowerCase(Locale.ROOT).replace(' ', '_');
        String base = "/assets/jurassicreborn/models/entities/" + name + "/skeleton/";
        String jsonPath = base + name + "_skeleton.json";
        ArrayList<TabulaModelContainer> models = new ArrayList<TabulaModelContainer>();
        try (InputStream in2 = SkeletonPoseHelper.class.getResourceAsStream(jsonPath);){
            JsonObject root;
            JsonObject poses;
            if (in2 != null && (poses = (root = JsonParser.parseReader((Reader)new InputStreamReader(in2)).getAsJsonObject()).getAsJsonObject("poses")) != null) {
                for (Map.Entry entry : poses.entrySet()) {
                    JsonArray arr = ((JsonElement)entry.getValue()).getAsJsonArray();
                    for (JsonElement el : arr) {
                        JsonObject poseObj = el.getAsJsonObject();
                        String poseFile = poseObj.get("pose").getAsString();
                        try {
                            TabulaModelContainer container = TabulaModelHelper.loadTabulaModel(base + poseFile);
                            if (container == null) continue;
                            models.add(container);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception in2) {
            // empty catch block
        }
        if (models.isEmpty()) {
            try {
                TabulaModelContainer fallback = TabulaModelHelper.loadTabulaModel(base + name + "_skeleton_idle");
                if (fallback != null) {
                    models.add(fallback);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return models;
    }
}

