/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.jei.skeletonassembly;

import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonInput;
import net.vit.jurassicreborn.common.items.ModItems;

public class SkeletonAssemblyRecipeExtension
implements IRecipeCategoryExtension {
    private static final int SLOT_SIZE = 18;
    private final SkeletonInput input;
    private static final int BACKGROUND_X = 15;
    private static final int BACKGROUND_Y = 15;

    public SkeletonAssemblyRecipeExtension(SkeletonInput input) {
        this.input = input;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focuses) {
        String[][] pattern = this.input.dinosaur.getRecipe();
        Map fossils = this.input.fresh ? (Map)ModItems.FRESH_BONES.get(this.input.dinosaur) : (Map)ModItems.BONES.get(this.input.dinosaur);
        for (int row = 0; row < pattern.length; ++row) {
            String[] line = pattern[row];
            for (int col = 0; col < 5; ++col) {
                RegistryObject reg;
                int slotX = 16 + col * 18 - 15;
                int slotY = 16 + row * 18 - 15;
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY);
                if (col >= line.length || line[col].isEmpty() || fossils == null || (reg = (RegistryObject)fossils.get(line[col])) == null) continue;
                slot.addItemStack(new ItemStack((ItemLike)reg.get()));
            }
        }
        int outY = (pattern.length * 18 - 18) / 2;
        ItemStack result = this.input.fresh ? new ItemStack((ItemLike)ModItems.FRESH_SKELETONS.get(this.input.dinosaur).get()) : new ItemStack((ItemLike)ModItems.FOSSIL_SKELETONS.get(this.input.dinosaur).get());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 125, 37).addItemStack(result);
    }
}

