/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.plants;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.plants.AjuginuculaSmithiiPlant;
import net.vit.jurassicreborn.common.plants.CalamitesPlant;
import net.vit.jurassicreborn.common.plants.DictyophyllumPlant;
import net.vit.jurassicreborn.common.plants.EncephalartosPlant;
import net.vit.jurassicreborn.common.plants.HeliconiaPlant;
import net.vit.jurassicreborn.common.plants.LadiniaSimplexPlant;
import net.vit.jurassicreborn.common.plants.OrontiumMackiiPlant;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.ScalyTreeFernPlant;
import net.vit.jurassicreborn.common.plants.SerennaVeriformansPlant;
import net.vit.jurassicreborn.common.plants.SmallCycadPlant;
import net.vit.jurassicreborn.common.plants.WestIndianLilacPlant;

public class PlantHandler {
    public static final Plant AJUGINUCULA_SMITHII = new AjuginuculaSmithiiPlant("Ajuginucula Smithii", (Supplier<? extends Block>)ModBlocks.AJUGINUCULA_SMITHII, 2000);
    public static final Plant SMALL_ROYAL_FERN = new Plant("Small Royal Fern", (Supplier<? extends Block>)ModBlocks.SMALL_ROYAL_FERN, 2000);
    public static final Plant CALAMITES = new CalamitesPlant("Calamites", (Supplier<? extends Block>)ModBlocks.CALAMITES_SAPLING, 1000);
    public static final Plant SMALL_CHAIN_FERN = new Plant("Small Chain Fern", (Supplier<? extends Block>)ModBlocks.SMALL_CHAIN_FERN, 2000);
    public static final Plant SMALL_CYCAD = new SmallCycadPlant("Small Cycad", (Supplier<? extends Block>)ModBlocks.SMALL_CYCAD, 2000);
    public static final Plant GINKGO = new Plant("Ginkgo", (Supplier<? extends Block>)ModBlocks.GINKGO_SAPLING, 1000);
    public static final Plant MAGNOLIA = new Plant("Magnolia", (Supplier<? extends Block>)ModBlocks.MAGNOLIA_SAPLING, 1000);
    public static final Plant CYCADEOIDEA = new Plant("Bennettitalean Cycadeoidea", (Supplier<? extends Block>)ModBlocks.CYCADEOIDEA, 2000);
    public static final Plant CRY_PANSY = new Plant("Cry Pansy", (Supplier<? extends Block>)ModBlocks.CRY_PANSY, 250);
    public static final Plant SCALY_TREE_FERN = new ScalyTreeFernPlant("Scaly Tree Fern", (Supplier<? extends Block>)ModBlocks.SCALY_TREE_FERN, 4000);
    public static final Plant ZAMITES = new Plant("Cycad Zamites", (Supplier<? extends Block>)ModBlocks.ZAMITES, 4000);
    public static final Plant DICKSONIA = new Plant("Dicksonia", (Supplier<? extends Block>)ModBlocks.DICKSONIA, 4000);
    public static final Plant WILD_ONION = new Plant("Wild Onion", (Supplier<? extends Block>)ModBlocks.WILD_ONION, 3000);
    public static final Plant DICROIDIUM_ZUBERI = new Plant("Dicroidium Zuberi", (Supplier<? extends Block>)ModBlocks.DICROIDIUM_ZUBERI, 4000);
    public static final Plant DICTYOPHYLLUM = new DictyophyllumPlant("Dictyophyllum", (Supplier<? extends Block>)ModBlocks.DICTYOPHYLLUM, 2000);
    public static final Plant WEST_INDIAN_LILAC = new WestIndianLilacPlant("West Indian Lilac", (Supplier<? extends Block>)ModBlocks.WEST_INDIAN_LILAC, 4000);
    public static final Plant SERENNA_VERIFORMANS = new SerennaVeriformansPlant("Serenna Veriformans", (Supplier<? extends Block>)ModBlocks.SERENNA_VERIFORMANS, 4000);
    public static final Plant LADINIA_SIMPLEX = new LadiniaSimplexPlant("Ladinia Simplex", (Supplier<? extends Block>)ModBlocks.LADINIA_SIMPLEX, 2000);
    public static final Plant ORONTIUM_MACKII = new OrontiumMackiiPlant("Orontium Mackii", (Supplier<? extends Block>)ModBlocks.ORONTIUM_MACKII, 1500);
    public static final Plant UMALTOLEPIS = new Plant("Umaltolepis", (Supplier<? extends Block>)ModBlocks.UMALTOLEPIS, 4000);
    public static final Plant LIRIODENDRITES = new Plant("Liriodendrites", (Supplier<? extends Block>)ModBlocks.LIRIODENDRITES, 4000);
    public static final Plant RAPHAELIA = new Plant("Raphaelia", (Supplier<? extends Block>)ModBlocks.RAPHAELIA, 2000);
    public static final Plant ENCEPHALARTOS = new EncephalartosPlant("Encephalartos", (Supplier<? extends Block>)ModBlocks.ENCEPHALARTOS, 4000);
    public static final Plant PSARONIUS = new Plant("Psaronius", (Supplier<? extends Block>)ModBlocks.PSARONIUS_SAPLING, 1000);
    public static final Plant PHOENIX = new Plant("Phoenix", (Supplier<? extends Block>)ModBlocks.PHOENIX_SAPLING, 1000);
    public static final Plant WILD_POTATO = new Plant("Wild Potato", (Supplier<? extends Block>)ModBlocks.WILD_POTATO_PLANT, 3000);
    public static final Plant ARAUCARIA = new Plant("Araucaria", (Supplier<? extends Block>)ModBlocks.ARAUCARIA_SAPLING, 1000);
    public static final Plant BRISTLE_FERN = new Plant("Bristle Fern", (Supplier<? extends Block>)ModBlocks.BRISTLE_FERN, 2000);
    public static final Plant CINNAMON_FERN = new Plant("Cinnamon Fern", (Supplier<? extends Block>)ModBlocks.CINNAMON_FERN, 2000);
    public static final Plant TEMPSKYA = new Plant("Tempskya", (Supplier<? extends Block>)ModBlocks.TEMPSKYA, 4000);
    public static final Plant WOOLLY_STALKED_BEGONIA = new Plant("Woolly Stalked Begonia", (Supplier<? extends Block>)ModBlocks.WOOLLY_STALKED_BEGONIA, 2000);
    public static final Plant LARGESTIPULE_LEATHER_ROOT = new Plant("Largestipule Leather Root", (Supplier<? extends Block>)ModBlocks.LARGESTIPULE_LEATHER_ROOT, 2000);
    public static final Plant RHACOPHYTON = new Plant("Rhacophyton", (Supplier<? extends Block>)ModBlocks.RHACOPHYTON, 4000);
    public static final Plant GRAMINIDITES_BAMBUSOIDES = new Plant("Graminidites Bambusoides", (Supplier<? extends Block>)ModBlocks.GRAMINIDITES_BAMBUSOIDES, 4000);
    public static final Plant ENALLHELIA = new Plant("Enallhelia", (Supplier<? extends Block>)ModBlocks.ENALLHELIA, 2000);
    public static final Plant AULOPORA = new Plant("Aulopora", (Supplier<? extends Block>)ModBlocks.AULOPORA, 2000);
    public static final Plant CLADOCHONUS = new Plant("Cladochonus", (Supplier<? extends Block>)ModBlocks.CLADOCHONUS, 2000);
    public static final Plant LITHOSTROTION = new Plant("Lithostrotion", (Supplier<? extends Block>)ModBlocks.LITHOSTROTION, 2000);
    public static final Plant STYLOPHYLLOPSIS = new Plant("Stylophyllopsis", (Supplier<? extends Block>)ModBlocks.STYLOPHYLLOPSIS, 2000);
    public static final Plant HIPPURITES_RADIOSUS = new Plant("Hippurites Radiosus", (Supplier<? extends Block>)ModBlocks.HIPPURITES_RADIOSUS, 2000);
    public static final Plant HELICONIA = new HeliconiaPlant("Heliconia", (Supplier<? extends Block>)ModBlocks.HELICONIA, 4000);
    public static final Plant RHAMNUS_SALICIFOLIUS = new Plant("Rhamnus Salicifolius", (Supplier<? extends Block>)ModBlocks.RHAMNUS_SALICIFOLIUS, 3000);
    public static final Plant EMPTY = new Plant("None", () -> Blocks.f_50016_, false, 0);
    private static final LinkedList<Plant> PLANTS = new LinkedList();
    public static final Object2IntLinkedOpenHashMap<ResourceLocation> RESOURCE_LOCATION_MAP = new Object2IntLinkedOpenHashMap();

    public static void init() {
        PlantHandler.registerPlant(AJUGINUCULA_SMITHII);
        PlantHandler.registerPlant(SMALL_ROYAL_FERN);
        PlantHandler.registerPlant(CALAMITES);
        PlantHandler.registerPlant(SMALL_CHAIN_FERN);
        PlantHandler.registerPlant(SMALL_CYCAD);
        PlantHandler.registerPlant(GINKGO);
        PlantHandler.registerPlant(CYCADEOIDEA);
        PlantHandler.registerPlant(CRY_PANSY);
        PlantHandler.registerPlant(SCALY_TREE_FERN);
        PlantHandler.registerPlant(ZAMITES);
        PlantHandler.registerPlant(DICKSONIA);
        PlantHandler.registerPlant(WILD_ONION);
        PlantHandler.registerPlant(DICROIDIUM_ZUBERI);
        PlantHandler.registerPlant(DICTYOPHYLLUM);
        PlantHandler.registerPlant(WEST_INDIAN_LILAC);
        PlantHandler.registerPlant(SERENNA_VERIFORMANS);
        PlantHandler.registerPlant(LADINIA_SIMPLEX);
        PlantHandler.registerPlant(ORONTIUM_MACKII);
        PlantHandler.registerPlant(UMALTOLEPIS);
        PlantHandler.registerPlant(LIRIODENDRITES);
        PlantHandler.registerPlant(RAPHAELIA);
        PlantHandler.registerPlant(ENCEPHALARTOS);
        PlantHandler.registerPlant(PSARONIUS);
        PlantHandler.registerPlant(PHOENIX);
        PlantHandler.registerPlant(WILD_POTATO);
        PlantHandler.registerPlant(ARAUCARIA);
        PlantHandler.registerPlant(CINNAMON_FERN);
        PlantHandler.registerPlant(BRISTLE_FERN);
        PlantHandler.registerPlant(TEMPSKYA);
        PlantHandler.registerPlant(WOOLLY_STALKED_BEGONIA);
        PlantHandler.registerPlant(LARGESTIPULE_LEATHER_ROOT);
        PlantHandler.registerPlant(RHACOPHYTON);
        PlantHandler.registerPlant(GRAMINIDITES_BAMBUSOIDES);
        PlantHandler.registerPlant(ENALLHELIA);
        PlantHandler.registerPlant(AULOPORA);
        PlantHandler.registerPlant(CLADOCHONUS);
        PlantHandler.registerPlant(LITHOSTROTION);
        PlantHandler.registerPlant(STYLOPHYLLOPSIS);
        PlantHandler.registerPlant(HIPPURITES_RADIOSUS);
        PlantHandler.registerPlant(HELICONIA);
        PlantHandler.registerPlant(RHAMNUS_SALICIFOLIUS);
        PlantHandler.registerPlant(EMPTY);
    }

    public static Plant getPlantById(int id) {
        if (id >= PLANTS.size() || id < 0) {
            return null;
        }
        Plant plant = PLANTS.get(id);
        if (plant == null) {
            return EMPTY;
        }
        return plant;
    }

    public static Plant getPlantById(ResourceLocation plant) {
        if (RESOURCE_LOCATION_MAP.containsKey((Object)plant)) {
            int id = RESOURCE_LOCATION_MAP.getInt((Object)plant);
            return PlantHandler.getPlantById(id);
        }
        return EMPTY;
    }

    public static ResourceLocation getPlantId(Plant plant) {
        return new ResourceLocation("jurassicreborn", plant.getName().toLowerCase(Locale.ROOT).replace(' ', '_'));
    }

    public static List<Plant> getPlants() {
        return PLANTS;
    }

    public static void registerPlant(Plant plant) {
        if (!PLANTS.contains(plant)) {
            PLANTS.add(plant);
            int id = PLANTS.indexOf(plant);
            RESOURCE_LOCATION_MAP.put((Object)new ResourceLocation("jurassicreborn", plant.getName().toLowerCase(Locale.ROOT).replace(' ', '_')), id);
        }
    }

    public static List<Plant> getPrehistoricPlantsAndTrees() {
        LinkedList<Plant> prehistoricPlants = new LinkedList<Plant>();
        for (Plant plant : PLANTS) {
            if (!plant.shouldRegister() || !plant.isPrehistoric()) continue;
            prehistoricPlants.add(plant);
        }
        return prehistoricPlants;
    }

    public static int getId(Plant plant) {
        return PLANTS.indexOf(plant);
    }

    public static List<Plant> getPrehistoricPlants() {
        LinkedList<Plant> prehistoricPlants = new LinkedList<Plant>();
        for (Plant plant : PLANTS) {
            if (!plant.shouldRegister() || !plant.isPrehistoric() || plant.isTree()) continue;
            prehistoricPlants.add(plant);
        }
        return prehistoricPlants;
    }
}

