/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.model;

import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.FenceType;

public final class ElectricFenceModels {
    public static Variant resolve(BlockState st, FenceType type) {
        boolean pole = (Boolean)st.m_61143_((Property)ElectricFenceBaseBlock.POLE);
        int conn = (Integer)st.m_61143_((Property)ElectricFenceBaseBlock.CONNECTIONS);
        boolean n = (Boolean)st.m_61143_((Property)ElectricFenceBaseBlock.NORTH);
        boolean s = (Boolean)st.m_61143_((Property)ElectricFenceBaseBlock.SOUTH);
        boolean w = (Boolean)st.m_61143_((Property)ElectricFenceBaseBlock.EAST);
        boolean e = (Boolean)st.m_61143_((Property)ElectricFenceBaseBlock.WEST);
        int facingRot = switch ((Direction)st.m_61143_((Property)ElectricFenceBaseBlock.FACING)) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
        String base = type.getPath();
        if (pole) {
            return new Variant(base + "_pole", (0 + facingRot) % 360);
        }
        if (conn == 0) {
            return new Variant(base, (0 + facingRot) % 360);
        }
        if (conn == 4) {
            return new Variant(base + "_lower", (0 + facingRot) % 360);
        }
        if (conn == 1 && (n || s) || conn == 2 && n && s) {
            return new Variant(base, (90 + facingRot) % 360);
        }
        if (conn == 1 && (e || w) || conn == 2 && e && w) {
            return new Variant(base, (180 + facingRot) % 360);
        }
        if (conn == 2) {
            if (n && e) {
                return new Variant(base + "_corner", (0 + facingRot) % 360);
            }
            if (e && s) {
                return new Variant(base + "_corner", (90 + facingRot) % 360);
            }
            if (s && w) {
                return new Variant(base + "_corner", (180 + facingRot) % 360);
            }
            if (w && n) {
                return new Variant(base + "_corner", (270 + facingRot) % 360);
            }
        }
        if (conn == 3) {
            if (!e) {
                return new Variant(base + "_corner_lower", (180 + facingRot) % 360);
            }
            if (!w) {
                return new Variant(base + "_corner_lower", (0 + facingRot) % 360);
            }
            if (!n) {
                return new Variant(base + "_corner_lower", (90 + facingRot) % 360);
            }
            if (!s) {
                return new Variant(base + "_corner_lower", (270 + facingRot) % 360);
            }
        }
        return new Variant(base, (0 + facingRot) % 360);
    }

    public static Vector3f rotationVec(int deg) {
        return Vector3f.f_122225_;
    }

    private ElectricFenceModels() {
    }

    public record Variant(String modelPath, int yRot) {
    }
}

