/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlock;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlockEntity;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailModel;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class TourRailBlockEntityRenderer
extends GeoBlockRenderer<TourRailBlockEntity> {
    public TourRailBlockEntityRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super(rendererProvider, (AnimatedGeoModel)new TourRailModel());
    }

    public ResourceLocation getTextureResource(TourRailBlockEntity tile) {
        return JurassicReborn.resource("textures/block/" + tile.getDirection().modelName + ".png");
    }

    public ResourceLocation getStripeTexture(TourRailBlockEntity tile) {
        return JurassicReborn.resource("textures/block/" + tile.getDirection().modelName + "_stripe.png");
    }

    public void render(TourRailBlockEntity tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        TourRailBlock.EnumRailDirection railDir = tile.getDirection();
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)tile));
        this.modelProvider.setLivingAnimations((Object)tile, Integer.valueOf(this.getInstanceId(tile)));
        poseStack.m_85836_();
        if (railDir.isAscending()) {
            Vector3f scale = switch (railDir.getFacing()) {
                case Direction.EAST, Direction.WEST -> new Vector3f(0.7f, 1.0f, 1.0f);
                case Direction.SOUTH, Direction.NORTH -> new Vector3f(1.0f, 1.0f, 0.7f);
                default -> new Vector3f(1.0f, 1.0f, 1.0f);
            };
            poseStack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
            double corr = 0.15;
            double neg = 0.125;
            switch (railDir.getFacing()) {
                case WEST: {
                    poseStack.m_85837_(corr + neg, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    poseStack.m_85837_(0.0, 0.0, corr + neg);
                    break;
                }
                case EAST: {
                    poseStack.m_85837_(corr, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85837_(0.0, 0.0, corr);
                    break;
                }
            }
        }
        poseStack.m_85837_(0.0, 0.01, 0.0);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)railDir.rotation));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureResource(tile));
        RenderType baseType = this.getRenderType((Object)tile, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureResource(tile));
        this.render(model, (Object)tile, partialTick, baseType, poseStack, bufferSource, null, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        BlockState state = tile.m_58900_();
        int rgb = ((TourRailBlock)state.m_60734_()).getSpeedType().getColor();
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getStripeTexture(tile));
        RenderType stripeType = this.getRenderType((Object)tile, partialTick, poseStack, bufferSource, null, packedLight, this.getStripeTexture(tile));
        this.render(model, (Object)tile, partialTick, stripeType, poseStack, bufferSource, null, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        poseStack.m_85849_();
    }
}

