/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.vit.jurassicreborn.common.entities.item.BlueprintEntity;

public class BlueprintRenderer
extends EntityRenderer<BlueprintEntity> {
    public BlueprintRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BlueprintEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float s = 0.0625f;
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        ResourceLocation tex = entity.f_19847_.texture;
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tex));
        this.renderLayer(entity, entity.m_7076_(), entity.m_7068_(), entity.f_19847_.sizeX, entity.f_19847_.sizeY, poseStack, vc);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(BlueprintEntity entity) {
        return entity.f_19847_.texture;
    }

    private void renderLayer(BlueprintEntity entity, int width, int height, int textureWidth, int textureHeight, PoseStack poseStack, VertexConsumer vc) {
        float centerWidth = (float)(-textureWidth) / 2.0f;
        float centerHeight = (float)(-textureHeight) / 2.0f;
        float pixelSize = 0.0625f;
        float depth = 1.0f;
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f mat = last.m_85861_();
        Matrix3f nMat = last.m_85864_();
        poseStack.m_85837_(0.0, 0.0, (double)(-depth + 0.5f));
        last = poseStack.m_85850_();
        mat = last.m_85861_();
        nMat = last.m_85864_();
        int x = 0;
        while ((float)x < (float)textureWidth * pixelSize) {
            int y = 0;
            while ((float)y < (float)textureHeight * pixelSize) {
                float i;
                float maxX = centerWidth + (float)(x + 1) / pixelSize;
                float minX = centerWidth + (float)x / pixelSize;
                float maxY = (float)(y + 1) / pixelSize - (float)textureHeight * 0.5f;
                float minY = (float)y / pixelSize - (float)textureHeight * 0.5f;
                float maxTextureX = ((float)textureWidth - (float)x / pixelSize) / (float)textureWidth;
                float minTextureX = ((float)textureWidth - (float)(x + 1) / pixelSize) / (float)textureWidth;
                float maxTextureY = ((float)textureHeight - (float)y / pixelSize) / (float)textureHeight;
                float minTextureY = ((float)textureHeight - (float)(y + 1) / pixelSize) / (float)textureHeight;
                int lightFront = this.computePackedLightForPixel(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                this.addQuad(vc, mat, nMat, maxX, minY, 0.0f, minTextureX, maxTextureY, 0, 0, -1, lightFront);
                this.addQuad(vc, mat, nMat, minX, minY, 0.0f, maxTextureX, maxTextureY, 0, 0, -1, lightFront);
                this.addQuad(vc, mat, nMat, minX, maxY, 0.0f, maxTextureX, minTextureY, 0, 0, -1, lightFront);
                this.addQuad(vc, mat, nMat, maxX, maxY, 0.0f, minTextureX, minTextureY, 0, 0, -1, lightFront);
                int lightBack = lightFront;
                this.addQuad(vc, mat, nMat, maxX, minY, depth, minTextureX, maxTextureY, 0, 0, 1, lightBack);
                this.addQuad(vc, mat, nMat, minX, minY, depth, maxTextureX, maxTextureY, 0, 0, 1, lightBack);
                this.addQuad(vc, mat, nMat, minX, maxY, depth, maxTextureX, minTextureY, 0, 0, 1, lightBack);
                this.addQuad(vc, mat, nMat, maxX, maxY, depth, minTextureX, minTextureY, 0, 0, 1, lightBack);
                for (i = minX; i < maxX; i += 1.0f) {
                    float uMax = (centerWidth - i) / (float)textureWidth;
                    float uMin = (centerWidth - (i + pixelSize)) / (float)textureWidth;
                    int lightSide = this.computePackedLightForPixel(entity, i, (minY + maxY) / 2.0f);
                    this.addQuad(vc, mat, nMat, i, minY, 0.0f, uMax, maxTextureY, -1, 0, 0, lightSide);
                    this.addQuad(vc, mat, nMat, i, minY, depth, uMax, maxTextureY, -1, 0, 0, lightSide);
                    this.addQuad(vc, mat, nMat, i, maxY, depth, uMin, minTextureY, -1, 0, 0, lightSide);
                    this.addQuad(vc, mat, nMat, i, maxY, 0.0f, uMin, minTextureY, -1, 0, 0, lightSide);
                    int lightSide2 = lightSide;
                    this.addQuad(vc, mat, nMat, i + 1.0f, minY, 0.0f, uMax, maxTextureY, 1, 0, 0, lightSide2);
                    this.addQuad(vc, mat, nMat, i + 1.0f, minY, depth, uMax, maxTextureY, 1, 0, 0, lightSide2);
                    this.addQuad(vc, mat, nMat, i + 1.0f, maxY, depth, uMin, minTextureY, 1, 0, 0, lightSide2);
                    this.addQuad(vc, mat, nMat, i + 1.0f, maxY, 0.0f, uMin, minTextureY, 1, 0, 0, lightSide2);
                }
                for (i = minY; i < maxY; i += 1.0f) {
                    float vMax = (centerHeight - i) / (float)textureHeight;
                    float vMin = (centerHeight - (i + pixelSize)) / (float)textureHeight;
                    int lightTopBottom = this.computePackedLightForPixel(entity, (minX + maxX) / 2.0f, i);
                    this.addQuad(vc, mat, nMat, minX, i, 0.0f, maxTextureX, vMax + 0.5f, 0, -1, 0, lightTopBottom);
                    this.addQuad(vc, mat, nMat, minX, i, depth, maxTextureX, vMin + 0.5f, 0, -1, 0, lightTopBottom);
                    this.addQuad(vc, mat, nMat, maxX, i, depth, minTextureX, vMin + 0.5f, 0, -1, 0, lightTopBottom);
                    this.addQuad(vc, mat, nMat, maxX, i, 0.0f, minTextureX, vMax + 0.5f, 0, -1, 0, lightTopBottom);
                    int lightTopBottom2 = lightTopBottom;
                    this.addQuad(vc, mat, nMat, minX, i + 1.0f, 0.0f, maxTextureX, vMax + 0.5f, 0, 1, 0, lightTopBottom2);
                    this.addQuad(vc, mat, nMat, minX, i + 1.0f, depth, maxTextureX, vMin + 0.5f, 0, 1, 0, lightTopBottom2);
                    this.addQuad(vc, mat, nMat, maxX, i + 1.0f, depth, minTextureX, vMin + 0.5f, 0, 1, 0, lightTopBottom2);
                    this.addQuad(vc, mat, nMat, maxX, i + 1.0f, 0.0f, minTextureX, vMax + 0.5f, 0, 1, 0, lightTopBottom2);
                }
                ++y;
            }
            ++x;
        }
    }

    private void addQuad(VertexConsumer vc, Matrix4f mat, Matrix3f nMat, float x, float y, float z, float u, float v, int nx, int ny, int nz, int light) {
        vc.m_85982_(mat, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(nMat, (float)nx, (float)ny, (float)nz).m_5752_();
    }

    private int computePackedLightForPixel(BlueprintEntity entity, float xzOffset, float yOffset) {
        double baseX = entity.m_20185_();
        double baseY = entity.m_20186_();
        double baseZ = entity.m_20189_();
        int posX = (int)Math.floor(baseX);
        int posY = (int)Math.floor(baseY + (double)(yOffset / 16.0f));
        int posZ = (int)Math.floor(baseZ);
        Direction dir = entity.m_6350_();
        if (dir == Direction.NORTH) {
            posX = (int)Math.floor(baseX + (double)(xzOffset / 16.0f));
        } else if (dir == Direction.WEST) {
            posZ = (int)Math.floor(baseZ - (double)(xzOffset / 16.0f));
        } else if (dir == Direction.SOUTH) {
            posX = (int)Math.floor(baseX - (double)(xzOffset / 16.0f));
        } else if (dir == Direction.EAST) {
            posZ = (int)Math.floor(baseZ + (double)(xzOffset / 16.0f));
        }
        BlockPos bp = new BlockPos(posX, posY, posZ);
        return LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)bp);
    }
}

