/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChasmosaurusEntity;

@OnlyIn(value=Dist.CLIENT)
public class ChasmosaurusAnimator
extends EntityAnimator<ChasmosaurusEntity> {
    @Override
    protected void performAnimations(AnimatableModel model, ChasmosaurusEntity entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        AdvancedModelBox body1 = model.getCube("body 1");
        AdvancedModelBox body2 = model.getCube("body 2");
        AdvancedModelBox body3 = model.getCube("body 3");
        AdvancedModelBox neck = model.getCube("neck");
        AdvancedModelBox head = model.getCube("head");
        AdvancedModelBox tail1 = model.getCube("tail 1");
        AdvancedModelBox tail2 = model.getCube("tail 2");
        AdvancedModelBox tail3 = model.getCube("tail 3");
        AdvancedModelBox tail4 = model.getCube("tail 4");
        AdvancedModelBox tail5 = model.getCube("tail 5");
        AdvancedModelBox tail6 = model.getCube("tail 6");
        AdvancedModelBox tail7 = model.getCube("tail 7");
        AdvancedModelBox[] neckChain = new AdvancedModelBox[]{head, neck};
        AdvancedModelBox[] bodyChain = new AdvancedModelBox[]{body1, body2, body3};
        AdvancedModelBox[] tailChain = new AdvancedModelBox[]{tail7, tail6, tail5, tail4, tail3, tail2, tail1};
        float idleSpeed = 0.1f;
        float idleDegree = 0.08f;
        model.bob(body1, idleSpeed, 0.65f, false, ticks, 1.0f);
        model.chainWave(bodyChain, idleSpeed * 0.6f, idleDegree * 0.35f, 2.0, ticks, 1.0f);
        model.chainWave(neckChain, idleSpeed * 0.6f, idleDegree * 0.6f, -2.0, ticks, 1.0f);
        model.chainSwing(new AdvancedModelBox[]{head}, idleSpeed * 0.9f, 0.1f, 0.0, ticks, 1.0f);
        model.bob(head, idleSpeed, 0.04f, false, ticks, 1.0f);
        model.chainSwing(tailChain, idleSpeed, 0.16f, -2.0, ticks, 1.0f);
        if (limbSwingAmount > 0.15f) {
            model.chainSwing(tailChain, 0.6f, 0.12f, -2.0, limbSwing, limbSwingAmount);
        }
        model.faceTarget(rotationYaw, rotationPitch, 0.9f, neck, head);
        entity.tailBuffer.applyChainSwingBuffer(tailChain);
    }
}

