/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.blocks.entities.HologramBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.network.SetHologramDinosaurPacket;

public class HologramSelectScreen
extends Screen {
    private final BlockPos blockPos;
    private List<Integer> dinoIds;
    private int currentIndex;
    private int poseIndex;
    private boolean rotating;
    private int rotation;
    private Button poseButton;
    private Button rotateButton;
    private Button angleButton;

    public HologramSelectScreen(BlockPos pos, int currentId, int pose, boolean rotating, int rotation) {
        super((Component)new TextComponent("Select Dinosaur"));
        this.blockPos = pos;
        this.currentIndex = currentId;
        this.poseIndex = pose;
        this.rotating = rotating;
        this.rotation = Math.floorMod(rotation, 360);
        if (!rotating) {
            this.rotation = HologramBlockEntity.snapRotation(this.rotation);
        }
    }

    protected void m_7856_() {
        int total = DinosaurHandler.count();
        this.dinoIds = IntStream.range(0, total).boxed().collect(Collectors.toList());
        if (this.dinoIds.isEmpty()) {
            this.dinoIds.add(0);
        }
        this.currentIndex = Math.floorMod(this.currentIndex, this.dinoIds.size());
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)new Button(cx - 60, cy, 20, 20, (Component)new TextComponent("<"), btn -> {
            this.currentIndex = (this.currentIndex - 1 + this.dinoIds.size()) % this.dinoIds.size();
            this.applySelectionLocally();
        }));
        this.m_142416_((GuiEventListener)new Button(cx + 40, cy, 20, 20, (Component)new TextComponent(">"), btn -> {
            this.currentIndex = (this.currentIndex + 1) % this.dinoIds.size();
            this.applySelectionLocally();
        }));
        this.poseButton = (Button)this.m_142416_((GuiEventListener)new Button(cx - 50, cy + 40, 100, 20, (Component)new TextComponent(this.getPoseName()), btn -> {
            this.poseIndex = (this.poseIndex + 1) % EntityAnimation.values().length;
            btn.m_93666_((Component)new TextComponent(this.getPoseName()));
            this.applySelectionLocally();
        }));
        this.rotateButton = (Button)this.m_142416_((GuiEventListener)new Button(cx - 50, cy + 70, 100, 20, (Component)new TextComponent(this.getRotateLabel()), btn -> {
            boolean bl = this.rotating = !this.rotating;
            if (!this.rotating) {
                this.rotation = HologramBlockEntity.snapRotation(this.rotation);
            }
            btn.m_93666_((Component)new TextComponent(this.getRotateLabel()));
            this.updateAngleButtonState();
            this.applySelectionLocally();
        }));
        this.angleButton = (Button)this.m_142416_((GuiEventListener)new Button(cx - 50, cy + 100, 100, 20, (Component)new TextComponent(this.getAngleLabel()), btn -> {
            this.rotation = HologramBlockEntity.snapRotation(this.rotation + 45);
            btn.m_93666_((Component)new TextComponent(this.getAngleLabel()));
            this.applySelectionLocally();
        }));
        this.updateAngleButtonState();
        this.m_142416_((GuiEventListener)new Button(cx - 50, cy + 130, 100, 20, (Component)new TextComponent("Confirm"), btn -> {
            int selectedId = this.dinoIds.get(this.currentIndex);
            Network.sendToServer(new SetHologramDinosaurPacket(this.blockPos, selectedId, this.poseIndex, this.rotating, this.rotation));
            this.applySelectionLocally();
            this.f_96541_.m_91152_(null);
        }));
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        HologramSelectScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 50), (int)0xFFFFFF);
        int id = this.dinoIds.get(this.currentIndex);
        Dinosaur dino = DinosaurHandler.getById(id);
        String name = dino.getName();
        HologramSelectScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)new TextComponent(name), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 10), (int)0xFFFF00);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    public boolean m_6913_() {
        return true;
    }

    private String getPoseName() {
        EntityAnimation anim = EntityAnimation.values()[Math.floorMod(this.poseIndex, EntityAnimation.values().length)];
        return "Pose: " + anim.name().toLowerCase().replace('_', ' ');
    }

    private String getRotateLabel() {
        return "Rotate: " + (this.rotating ? "On" : "Off");
    }

    private String getAngleLabel() {
        return "Angle: " + this.rotation + "\u00c2\u00b0";
    }

    private void updateAngleButtonState() {
        if (this.angleButton != null) {
            this.angleButton.f_93624_ = !this.rotating;
            this.angleButton.f_93623_ = !this.rotating;
            this.angleButton.m_93666_((Component)new TextComponent(this.getAngleLabel()));
        }
    }

    private void applySelectionLocally() {
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.dinoIds == null || this.dinoIds.isEmpty()) {
            return;
        }
        BlockEntity be = this.f_96541_.f_91073_.m_7702_(this.blockPos);
        if (!(be instanceof HologramBlockEntity)) {
            return;
        }
        HologramBlockEntity hologram = (HologramBlockEntity)be;
        int selectedId = this.dinoIds.get(Math.floorMod(this.currentIndex, this.dinoIds.size()));
        hologram.setDinosaurById(selectedId);
        hologram.setPoseIndex(this.poseIndex);
        hologram.setRotating(this.rotating);
        hologram.setRot(this.rotation);
    }
}

