/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.ancientplants;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class AncientPlantBlock
extends BushBlock {
    private static final int DENSITY_PER_AREA = 4;
    private static final int SPREAD_RADIUS = 6;

    public AncientPlantBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
    }

    public AncientPlantBlock() {
        super(ModBlocks.defaultPlant().m_60977_());
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected boolean isNearWater(ServerLevel level, BlockPos pos) {
        for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_142082_(-8, -3, -8), (BlockPos)pos.m_142082_(8, 3, 8))) {
            if (!level.m_6425_(p).m_205070_(FluidTags.f_13131_) || !(pos.m_123331_((Vec3i)p) < 9.0)) continue;
            return true;
        }
        return false;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!level.m_46469_().m_46207_(GameRuleHandler.ANCIENT_PLANT_SPREAD)) {
            return;
        }
        if (!this.isNearWater(level, pos)) {
            return;
        }
        if (random.nextInt(8) != 0) {
            return;
        }
        int allowedInArea = 4;
        for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_142082_(-6, -1, -6), (BlockPos)pos.m_142082_(6, 1, 6))) {
            if (p.equals((Object)pos) || !level.m_8055_(p).m_60713_((Block)this) || --allowedInArea > 0) continue;
            return;
        }
        BlockPos target = null;
        int attempts = 4;
        while (target == null && attempts-- > 0) {
            int z;
            int y;
            int x = random.nextInt(13) - 6;
            BlockPos candidate = pos.m_142082_(x, y = random.nextInt(3) - 1, z = random.nextInt(13) - 6);
            BlockPos placement = this.findGround(level, candidate);
            if (placement == null || !this.m_7898_(this.m_49966_(), (LevelReader)level, placement)) continue;
            target = placement;
        }
        if (target != null) {
            this.spread(level, target);
        }
    }

    protected void spread(ServerLevel level, BlockPos pos) {
        level.m_46597_(pos, this.m_49966_());
    }

    protected BlockPos findGround(ServerLevel level, BlockPos start) {
        BlockState here;
        BlockState below;
        int i;
        BlockPos pos = start;
        for (i = 0; i < 8; ++i) {
            below = level.m_8055_(pos.m_7495_());
            if (this.canPlace(below, here = level.m_8055_(pos), pos, (LevelReader)level)) {
                return pos;
            }
            pos = pos.m_7495_();
        }
        pos = start;
        for (i = 0; i < 8; ++i) {
            below = level.m_8055_(pos.m_7495_());
            if (this.canPlace(below, here = level.m_8055_(pos), pos, (LevelReader)level)) {
                return pos;
            }
            pos = pos.m_7494_();
        }
        return null;
    }

    protected boolean canPlace(BlockState down, BlockState here, BlockPos pos, LevelReader level) {
        return down.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP) && (here.m_60795_() || here.m_60767_().m_76336_()) && !level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    protected boolean m_6266_(BlockState soil, BlockGetter level, BlockPos pos) {
        return soil.m_60713_(Blocks.f_50440_) || soil.m_60713_(Blocks.f_50493_) || soil.m_60713_(Blocks.f_50546_) || soil.m_60713_(Blocks.f_152549_) || soil.m_60713_(Blocks.f_50599_) || soil.m_60713_(Blocks.f_50195_) || soil.m_60713_(Blocks.f_50093_) || soil.m_60713_(Blocks.f_49992_) || soil.m_60713_(Blocks.f_49993_) || soil.m_60713_(Blocks.f_49994_) || soil.m_60713_(Blocks.f_50129_);
    }
}

