/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer.DNACombinatorHybridizerBlock;
import net.vit.jurassicreborn.common.blocks.entities.DNABlocks.DNACombinatorHybridizer.DNACombinatorHybridizerMenu;
import net.vit.jurassicreborn.common.blocks.entities.MachineBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import net.vit.jurassicreborn.common.blocks.inventory.DNACombinatorHybridizerItemHandler;
import net.vit.jurassicreborn.common.blocks.inventory.ItemHandlerBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Hybrid;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.network.Network;
import org.jetbrains.annotations.NotNull;

public class DNACombinatorHybridizerBlockEntity
extends MachineBlockEntity
implements MenuProvider,
ItemHandlerBlockEntity {
    public static final int SLOTS = 12;
    public static final int[] HYBRIDIZER_INPUTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int[] COMBINATOR_INPUTS = new int[]{8, 9};
    public static final int[] HYBRIDIZER_OUTPUTS = new int[]{10};
    public static final int[] COMBINATOR_OUTPUTS = new int[]{11};
    public int processTime;
    protected final DNACombinatorHybridizerItemHandler machineItemStackHandler = new DNACombinatorHybridizerItemHandler(12, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{10, 11});
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            if (pIndex >= 2) {
                if (pIndex == 2) {
                    return DNACombinatorHybridizerBlockEntity.this.getMode() ? 1 : 0;
                }
                if (pIndex == 3) {
                    return DNACombinatorHybridizerBlockEntity.this.m_58899_().m_123341_();
                }
                if (pIndex == 4) {
                    return DNACombinatorHybridizerBlockEntity.this.m_58899_().m_123342_();
                }
                if (pIndex == 5) {
                    return DNACombinatorHybridizerBlockEntity.this.m_58899_().m_123343_();
                }
                return 0;
            }
            if (pIndex == 0) {
                return DNACombinatorHybridizerBlockEntity.this.processTime;
            }
            if (pIndex == 1) {
                return DNACombinatorHybridizerBlockEntity.this.getTotalProcessTime();
            }
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex >= 2 && pIndex == 2 && pValue < 2 && pValue > -1) {
                DNACombinatorHybridizerBlockEntity.this.setMode(pValue == 1);
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.machineItemStackHandler;
    }

    public DNACombinatorHybridizerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DNA_COMBINATOR_HYBRIDIZER.get(), pPos, pBlockState);
    }

    protected int getProcess(int slot) {
        return 0;
    }

    public boolean isProcessing() {
        return this.processTime > 0;
    }

    private Dinosaur getHybrid() {
        ItemStack[] stacks = (ItemStack[])IntStream.range(0, 8).mapToObj(this::getItem).toArray(ItemStack[]::new);
        return this.getHybrid(stacks);
    }

    private Dinosaur getHybrid(ItemStack ... discs) {
        Dinosaur hybrid = null;
        Dinosaur[] dinosaurs = new Dinosaur[discs.length];
        for (int i = 0; i < dinosaurs.length; ++i) {
            dinosaurs[i] = this.getDino(discs[i]);
        }
        for (Dinosaur dino : Dinosaur.DINOS) {
            if (!(dino instanceof Hybrid)) continue;
            Hybrid dinoHybrid = (Hybrid)((Object)dino);
            int count = 0;
            boolean extra = false;
            ArrayList<Class> usedGenes = new ArrayList<Class>();
            for (Dinosaur discDinosaur : dinosaurs) {
                Class match = null;
                for (Class clazz : dinoHybrid.getDinosaurs()) {
                    if (!clazz.isInstance(discDinosaur) || usedGenes.contains(clazz)) continue;
                    match = clazz;
                }
                if (match != null && match.isInstance(discDinosaur)) {
                    usedGenes.add(match);
                    ++count;
                    continue;
                }
                if (discDinosaur == null) continue;
                extra = true;
            }
            if (extra || count != dinoHybrid.getDinosaurs().length) continue;
            hybrid = dino;
            break;
        }
        return hybrid;
    }

    private Dinosaur getDino(ItemStack disc) {
        if (!disc.m_41619_() && disc.m_41782_()) {
            DinoDNA data = DinoDNA.readFromNBT(disc.m_41783_());
            if (data == null) {
                return Dinosaur.EMPTY;
            }
            return data.getDNAQuality() == 100 ? data.getDinosaur() : null;
        }
        return null;
    }

    @Override
    public boolean canProcess(ItemStack ... inputs) {
        if (this.getMode()) {
            return this.getItem(10).m_41619_() && this.getHybrid() != null;
        }
        ItemStack left = this.getItem(8);
        ItemStack right = this.getItem(9);
        if (!left.m_41619_() && left.m_41720_() == ModItems.STORAGE_DISC.get() && !right.m_41619_() && right.m_41720_() == ModItems.STORAGE_DISC.get() && left.m_41783_() != null && right.m_41783_() != null && this.getItem(11).m_41619_()) {
            String rightID;
            String leftID = left.m_41783_().m_128469_("DNA").m_128461_("StorageId");
            if (!leftID.equals(rightID = right.m_41783_().m_128469_("DNA").m_128461_("StorageId"))) {
                return false;
            }
            if (leftID.equals("DinoDNA")) {
                DinoDNA dna1 = DinoDNA.readFromNBT(left.m_41783_());
                DinoDNA dna2 = DinoDNA.readFromNBT(right.m_41783_());
                if (dna1 == null || dna2 == null) {
                    return false;
                }
                return dna1.getDinosaur() == dna2.getDinosaur();
            }
            if (leftID.equals("PlantDNA")) {
                PlantDNA dna1 = PlantDNA.readFromNBT(left.m_41783_());
                PlantDNA dna2 = PlantDNA.readFromNBT(right.m_41783_());
                return dna1.getPlant().equals((Object)dna2.getPlant());
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> processItem(ItemStack ... inputs) {
        if (this.f_58857_ == null) {
            return List.of(ItemStack.f_41583_);
        }
        if (this.canProcess(new ItemStack[0])) {
            if (this.getMode()) {
                Dinosaur hybrid = this.getHybrid();
                CompoundTag nbt = new CompoundTag();
                DinoDNA dna = new DinoDNA(this.getHybrid(), 100, GeneticsHelper.randomGenetics(this.f_58857_.f_46441_));
                DinoDNA firstDNA = DinoDNA.readFromNBT(this.getItem(0).m_41783_());
                if (firstDNA != null) {
                    dna = new DinoDNA(hybrid, 100, firstDNA.getGenetics());
                }
                dna.writeToNBT(nbt);
                ItemStack output = new ItemStack((ItemLike)ModItems.STORAGE_DISC.get());
                output.m_41751_(nbt);
                StorageDiscItem.applyCustomModelData(output);
                this.mergeStack(this.getOutputSlot(output), output);
            } else {
                ItemStack output = new ItemStack((ItemLike)ModItems.STORAGE_DISC.get());
                String storageId = this.getItem(8).m_41784_().m_128469_("DNA").m_128461_("StorageId");
                if (storageId.equals("DinoDNA")) {
                    DinoDNA dna1 = DinoDNA.readFromNBT(this.getItem(8).m_41783_());
                    DinoDNA dna2 = DinoDNA.readFromNBT(this.getItem(9).m_41783_());
                    if (dna1 == null || dna2 == null) {
                        return List.of(ItemStack.f_41583_);
                    }
                    int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                    if (newQuality > 100) {
                        newQuality = 100;
                    }
                    DinoDNA newDNA = new DinoDNA(dna1.getDinosaur(), newQuality, dna1.getGenetics());
                    CompoundTag outputTag = new CompoundTag();
                    newDNA.writeToNBT(outputTag);
                    output.m_41751_(outputTag);
                    StorageDiscItem.applyCustomModelData(output);
                } else if (storageId.equals("PlantDNA")) {
                    PlantDNA dna1 = PlantDNA.readFromNBT(this.getItem(8).m_41783_());
                    PlantDNA dna2 = PlantDNA.readFromNBT(this.getItem(9).m_41783_());
                    if (dna1 == null || dna2 == null) {
                        return List.of(ItemStack.f_41583_);
                    }
                    int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                    if (newQuality > 100) {
                        newQuality = 100;
                    }
                    PlantDNA newDNA = new PlantDNA(dna1.getPlant(), newQuality);
                    CompoundTag outputTag = new CompoundTag();
                    newDNA.writeToNBT(outputTag);
                    output.m_41751_(outputTag);
                    StorageDiscItem.applyCustomModelData(output);
                }
                this.mergeStack(11, output);
                this.decreaseStackSize(8);
                this.decreaseStackSize(9);
            }
        }
        return List.of(ItemStack.f_41583_);
    }

    @Override
    protected void mergeStack(int slot, ItemStack stack) {
        ItemStack previous = this.getItem(slot);
        if (previous.m_41619_()) {
            this.setItem(slot, stack);
        } else if (ItemStack.m_41746_((ItemStack)previous, (ItemStack)stack) && ItemStack.m_41746_((ItemStack)previous, (ItemStack)stack)) {
            previous.m_41764_(previous.m_41613_() + stack.m_41613_());
        }
    }

    protected void decreaseStackSize(int slot) {
        ItemStack stack = this.getItem(slot);
        stack.m_41774_(1);
        this.setItem(slot, stack);
    }

    public int getTotalProcessTime() {
        return 1000;
    }

    protected int[] getInputs() {
        return this.getMode() ? HYBRIDIZER_INPUTS : COMBINATOR_INPUTS;
    }

    protected int[] getOutputs() {
        return this.getMode() ? HYBRIDIZER_OUTPUTS : COMBINATOR_OUTPUTS;
    }

    @Override
    public Tag getMachineData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("ProcessTime", this.processTime);
        return data;
    }

    @Override
    public void readMachineData(Tag data) {
        CompoundTag machineData = (CompoundTag)data;
        this.processTime = machineData.m_128451_("ProcessTime");
    }

    public boolean getMode() {
        if (this.m_58904_() == null) {
            return false;
        }
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        return state.m_61138_((Property)DNACombinatorHybridizerBlock.MODE) && (Boolean)state.m_61143_((Property)DNACombinatorHybridizerBlock.MODE) != false;
    }

    public void setMode(boolean mode) {
        if (this.m_58904_() == null) {
            return;
        }
        Network.switchHybridizerCombinerMode(mode, this.m_58899_(), (ResourceKey<Level>)this.m_58904_().m_46472_());
        this.processTime = 0;
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)DNACombinatorHybridizerBlock.MODE, (Comparable)Boolean.valueOf(mode)), 0);
    }

    @NotNull
    public Component m_5446_() {
        return this.m_8077_() ? this.m_7755_() : new TranslatableComponent(this.getMode() ? "container.dna_hybridizer" : "container.dna_combinator");
    }

    @Override
    @NotNull
    protected Component getDefaultName() {
        return new TranslatableComponent(this.getMode() ? "container.dna_hybridizer" : "container.dna_combinator");
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pInventory, Player player) {
        return new DNACombinatorHybridizerMenu(pContainerId, pInventory, this.machineItemStackHandler, this.data);
    }

    public int getOutputSlot(ItemStack output) {
        int[] outputs;
        for (int slot : outputs = this.getOutputs()) {
            ItemStack stack = this.getItem(slot);
            if (!stack.m_41619_() && (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)output) || stack.m_41613_() + output.m_41613_() > stack.m_41741_())) continue;
            return slot;
        }
        return -1;
    }

    public static void tick(Level level, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull DNACombinatorHybridizerBlockEntity pBlockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean flag = pBlockEntity.isProcessing();
        boolean dirty = false;
        boolean hasInput = false;
        for (int input : pBlockEntity.getInputs()) {
            if (12 <= input || pBlockEntity.getItem(input).m_41619_()) continue;
            hasInput = true;
            break;
        }
        if (hasInput && pBlockEntity.canProcess(new ItemStack[0])) {
            ++pBlockEntity.processTime;
            if (pBlockEntity.processTime >= pBlockEntity.getTotalProcessTime()) {
                pBlockEntity.processItem(new ItemStack[0]);
                pBlockEntity.processTime = 0;
            }
            dirty = true;
        } else if (pBlockEntity.isProcessing()) {
            if (pBlockEntity.shouldResetProgress()) {
                pBlockEntity.processTime = 0;
            } else if (pBlockEntity.processTime > 0) {
                --pBlockEntity.processTime;
            }
            dirty = true;
        }
        if (flag != pBlockEntity.isProcessing()) {
            dirty = true;
        }
        if (dirty) {
            pBlockEntity.m_6596_();
        }
    }

    protected boolean shouldResetProgress() {
        return true;
    }
}

