/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.cleaner;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.vit.jurassicreborn.common.blocks.entities.MachineItemStackHandler;
import net.vit.jurassicreborn.common.blocks.entities.ModMenuTypes;
import net.vit.jurassicreborn.common.blocks.entities.cleaner.CleanerBlockEntity;
import net.vit.jurassicreborn.common.blocks.inventory.CleanerItemHandler;

public class CleanerMenu
extends AbstractContainerMenu {
    private Inventory playerInv;
    private CleanerBlockEntity instance;
    private final MachineItemStackHandler cleaningStation;
    private final ContainerData cleaningStationData;
    public static final int INPUT_SLOT = 0;
    public static final int BUCKET_SLOT = 1;
    public static final int OUTPUT_SLOT_END = 5;

    public CleanerMenu(int id, Inventory inventory) {
        this(id, inventory, CleanerItemHandler.instance(), (ContainerData)new SimpleContainerData(2));
    }

    public CleanerMenu(int pContainerId, Inventory inventory, MachineItemStackHandler cleaningStation, ContainerData stationData) {
        super((MenuType)ModMenuTypes.CLEANER.get(), pContainerId);
        this.cleaningStation = cleaningStation;
        this.cleaningStationData = stationData;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 0, 56, 17));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 1, 56, 53));
        int slotIncrement = 18;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 2, 108, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 3, 108 + slotIncrement, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 4, 108 + slotIncrement * 2, 26));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 5, 108, 26 + slotIncrement));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 6, 108 + slotIncrement, 26 + slotIncrement));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)cleaningStation, 7, 108 + slotIncrement * 2, 26 + slotIncrement));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.cleaningStationData);
        this.playerInv = inventory;
    }

    public int getAmountOfFluid() {
        return this.cleaningStationData.m_6413_(0);
    }

    public boolean isCleaning() {
        if (this.instance != null) {
            return this.instance.isCleaning();
        }
        return this.cleaningStationData.m_6413_(1) != 0;
    }

    public int getProgress() {
        if (this.instance != null) {
            return (int)Math.ceil((double)this.instance.getProgress() * 0.11);
        }
        return (int)Math.ceil((double)this.cleaningStationData.m_6413_(1) * 0.11);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < this.cleaningStation.getSlots() ? !this.m_38903_(itemstack1, this.cleaningStation.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.cleaningStation.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public void setInstance(CleanerBlockEntity entity) {
        this.instance = entity;
    }

    public static class EmptyFluidSlot
    extends Slot {
        public EmptyFluidSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }
    }
}

