/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.vit.jurassicreborn.common.recipes.cleaner.CleaningRecipe;

public class CleaningRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<?> type;

    public CleaningRecipeBuilder(RecipeSerializer<?> pType, Ingredient pIngredient, ItemLike pResult, int pCount) {
        this.type = pType;
        this.result = pResult.m_5456_();
        this.ingredient = pIngredient;
        this.count = pCount;
    }

    public static CleaningRecipeBuilder cleaning(ItemLike like, ItemLike pResult) {
        return CleaningRecipeBuilder.cleaning(Ingredient.m_43929_((ItemLike[])new ItemLike[]{like}), pResult);
    }

    public static CleaningRecipeBuilder cleaning(Ingredient pIngredient, ItemLike pResult) {
        return new CleaningRecipeBuilder(CleaningRecipe.INSTANCE, pIngredient, pResult, 1);
    }

    public CleaningRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public CleaningRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        CreativeModeTab category = this.result.m_41471_();
        String folder = category != null ? category.m_40783_() : "misc";
        ResourceLocation advancementId = new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + folder + "/" + pRecipeId.m_135815_());
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.type, this.group == null ? "" : this.group, this.ingredient, this.result, this.count, this.advancement, advancementId));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<?> type;

        public Result(ResourceLocation pId, RecipeSerializer<?> pType, String pGroup, Ingredient pIngredient, Item pResult, int pCount, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId) {
            this.id = pId;
            this.type = pType;
            this.group = pGroup;
            this.ingredient = pIngredient;
            this.result = pResult;
            this.count = pCount;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("input", this.ingredient.m_43942_());
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            resultObject.addProperty("count", (Number)this.count);
            pJson.add("output", (JsonElement)resultObject);
            pJson.addProperty("count", (Number)this.count);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

