/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.datagen;

import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.fossil.NestFossilBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.datagen.ModBlockFamilies;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;

public class JRBlockLoot
extends BlockLoot {
    private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    private static LootTable.Builder simpleSingleItem(ItemLike item) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)).m_6509_(ExplosionCondition.m_81661_()));
    }

    protected void addTables() {
        this.m_124288_((Block)ModBlocks.ARAUCARIA_SAPLING.get());
        this.m_124288_((Block)ModBlocks.GINKGO_SAPLING.get());
        this.m_124288_((Block)ModBlocks.CALAMITES_SAPLING.get());
        this.m_124288_((Block)ModBlocks.PHOENIX_SAPLING.get());
        this.m_124288_((Block)ModBlocks.PSARONIUS_SAPLING.get());
        this.m_124288_((Block)ModBlocks.MAGNOLIA_SAPLING.get());
        this.m_124288_((Block)ModBlocks.WEST_INDIAN_LILAC.get());
        this.m_124175_((Block)ModBlocks.POTTED_ARAUCARIA_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.ARAUCARIA_SAPLING.get())));
        this.m_124175_((Block)ModBlocks.POTTED_GINKGO_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.GINKGO_SAPLING.get())));
        this.m_124175_((Block)ModBlocks.POTTED_CALAMITES_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.CALAMITES_SAPLING.get())));
        this.m_124175_((Block)ModBlocks.POTTED_PHOENIX_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.PHOENIX_SAPLING.get())));
        this.m_124175_((Block)ModBlocks.POTTED_PSARONIUS_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.PSARONIUS_SAPLING.get())));
        this.m_124175_((Block)ModBlocks.POTTED_MAGNOLIA_SAPLING.get(), block -> JRBlockLoot.m_124270_((ItemLike)((ItemLike)ModBlocks.MAGNOLIA_SAPLING.get())));
        PlantHandler.getPlants().stream().filter(Plant::shouldRegister).map(Plant::getBlock).forEach(block -> this.m_124165_((Block)block, JRBlockLoot.simpleSingleItem((ItemLike)block)));
        this.m_124288_((Block)ModBlocks.SKULL_DISPLAY.get());
        this.m_124288_((Block)ModBlocks.BUG_CRATE.get());
        this.m_124288_((Block)ModBlocks.HOLOGRAM_BLOCK.get());
        this.m_124288_((Block)ModBlocks.PARK_BENCH.get());
        this.m_124288_((Block)ModBlocks.TRASH_CAN.get());
        this.m_124288_((Block)ModBlocks.AMBER_BLOCK.get());
        this.m_124288_((Block)ModBlocks.SKELETON_ASSEMBLY.get());
        this.m_124288_((Block)ModBlocks.CLEANING_STATION.get());
        this.m_124288_((Block)ModBlocks.CLEAR_GLASS.get());
        this.m_124288_((Block)ModBlocks.CLEAR_GLASS_PANE.get());
        this.m_124288_((Block)ModBlocks.AMBER_MOSQUITO.get());
        this.m_124288_((Block)ModBlocks.AMBER_APHID.get());
        this.m_124288_((Block)ModBlocks.SEA_LAMPREY.get());
        this.m_124288_((Block)ModBlocks.FROZEN_LEECH.get());
        this.m_124147_((Block)ModBlocks.CULTIVATE_BOTTOM.get(), (ItemLike)ModItems.CULTIVATORS.get(DyeColor.BLACK).get());
        this.m_124165_((Block)ModBlocks.CULTIVATE_TOP.get(), JRBlockLoot.m_124125_());
        for (Dinosaur dino : Dinosaur.DINOS) {
            Block fossilBlock;
            Block encasedBlock = ModBlocks.getEncasedBlockFor(dino);
            if (encasedBlock != null) {
                this.m_124288_(encasedBlock);
            }
            if ((fossilBlock = ModBlocks.getFossilBlockFor(dino)) == null) continue;
            this.m_124288_(fossilBlock);
        }
        this.m_124175_((Block)ModBlocks.WILD_POTATO_PLANT.get(), block -> JRBlockLoot.m_124142_((Block)block, (Item)((Item)ModItems.WILD_POTATO.get()), (Item)((Item)ModItems.WILD_POTATO_SEEDS.get()), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61408_, 5))));
        this.m_124175_((Block)ModBlocks.AJUGINUCULA_SMITHII.get(), block -> JRBlockLoot.m_124142_((Block)block, (Item)((Item)ModItems.AJUGINUCULA_SMITHII_LEAVES.get()), (Item)((Item)ModItems.AJUGINUCULA_SMITHII_SEEDS.get()), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61409_, 7))));
        this.m_124175_((Block)ModBlocks.RHAMNUS_SALICIFOLIUS.get(), block -> JRBlockLoot.m_124142_((Block)block, (Item)((Item)ModItems.RHAMNUS_BERRIES.get()), (Item)((Item)ModItems.RHAMNUS_SEEDS.get()), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61409_, 7))));
        this.m_124175_((Block)ModBlocks.WILD_ONION.get(), block -> JRBlockLoot.m_124142_((Block)block, (Item)((Item)ModItems.WILD_ONION.get()), (Item)((Item)ModItems.WILD_ONION.get()), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61408_, 5))));
        this.m_124288_((Block)ModBlocks.DEAD_AULOPORA.get());
        this.m_124288_((Block)ModBlocks.DEAD_CLADOCHONUS.get());
        this.m_124288_((Block)ModBlocks.DEAD_ENALLHELIA.get());
        this.m_124288_((Block)ModBlocks.DEAD_HIPPURITES_RADIOSUS.get());
        this.m_124288_((Block)ModBlocks.DEAD_LITHOSTROTION.get());
        this.m_124288_((Block)ModBlocks.DEAD_STYLOPHYLLOPSIS.get());
        this.m_124165_((Block)ModBlocks.DISPLAY_BLOCK.get(), JRBlockLoot.m_124125_());
        this.m_124288_((Block)ModBlocks.DNA_COMBINER_HYBRIDIZER.get());
        this.m_124288_((Block)ModBlocks.DNA_EXTRACTOR.get());
        this.m_124288_((Block)ModBlocks.DNA_SEQUENCER.get());
        this.m_124288_((Block)ModBlocks.DNA_SYNTHESIZER.get());
        this.m_124288_((Block)ModBlocks.EMBRYO_CALCIFICATION_MACHINE.get());
        this.m_124288_((Block)ModBlocks.EMBRYONIC_MACHINE.get());
        this.m_124288_((Block)ModBlocks.ENCASED_FAUNA_FOSSIL.get());
        this.m_124165_((Block)ModBlocks.FLORA_FOSSIL.get(), JRBlockLoot.createMultiItemTable((ItemLike)ModItems.PLANT_FOSSIL.get(), (ItemLike)ModItems.PLANT_FOSSIL_0.get(), (ItemLike)ModItems.PLANT_FOSSIL_1.get(), (ItemLike)ModItems.PLANT_FOSSIL_2.get(), (ItemLike)ModItems.PLANT_FOSSIL_3.get(), (ItemLike)ModItems.TWIG_FOSSIL.get()));
        this.m_124165_((Block)ModBlocks.DEEPSLATE_FLORA_FOSSIL.get(), JRBlockLoot.createMultiItemTable((ItemLike)ModItems.PLANT_FOSSIL.get(), (ItemLike)ModItems.PLANT_FOSSIL_0.get(), (ItemLike)ModItems.PLANT_FOSSIL_1.get(), (ItemLike)ModItems.PLANT_FOSSIL_2.get(), (ItemLike)ModItems.PLANT_FOSSIL_3.get()));
        this.m_124288_((Block)ModBlocks.FAUNA_FOSSIL.get());
        this.m_124288_((Block)ModBlocks.FEEDER.get());
        this.m_124288_((Block)ModBlocks.FOSSIL_GRINDER.get());
        this.m_124288_((Block)ModBlocks.FOSSILIZED_TRACKWAY_BIPED_MEDIUM.get());
        this.m_124288_((Block)ModBlocks.FOSSILIZED_TRACKWAY_BIPED_SMALL.get());
        this.m_124288_((Block)ModBlocks.FOSSILIZED_TRACKWAY_RAPTOR.get());
        this.m_124288_((Block)ModBlocks.GRACILARIA.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_BRICKS.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_COBBLESTONE.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_MIXED_PATH.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_PATHWAY.get());
        this.m_124175_((Block)ModBlocks.GYPSUM_STONE.get(), block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)JRBlockLoot.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GYPSUM_POWDER.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))))));
        this.m_124288_((Block)ModBlocks.GYPSUM_STONE_PANEL.get());
        this.m_124288_((Block)ModBlocks.GYPSUM_TILES.get());
        this.m_124288_((Block)ModBlocks.HIGH_SECURITY_FENCE_BASE.get());
        this.m_124288_((Block)ModBlocks.HIGH_SECURITY_FENCE_POLE.get());
        this.m_124288_((Block)ModBlocks.HIGH_SECURITY_FENCE_WIRE.get());
        this.m_124288_((Block)ModBlocks.INCUBATOR.get());
        this.m_124147_((Block)ModBlocks.KRILL_SWARM.get(), (ItemLike)ModItems.KRILL.get());
        this.m_124288_((Block)ModBlocks.LOW_SECURITY_FENCE_BASE.get());
        this.m_124288_((Block)ModBlocks.LOW_SECURITY_FENCE_POLE.get());
        this.m_124288_((Block)ModBlocks.LOW_SECURITY_FENCE_WIRE.get());
        this.m_124288_((Block)ModBlocks.MED_SECURITY_FENCE_BASE.get());
        this.m_124288_((Block)ModBlocks.MED_SECURITY_FENCE_POLE.get());
        this.m_124288_((Block)ModBlocks.MED_SECURITY_FENCE_WIRE.get());
        this.m_124288_((Block)ModBlocks.PALEO_BALE_CYCAD.get());
        this.m_124288_((Block)ModBlocks.PALEO_BALE_CYCADEOIDEA.get());
        this.m_124288_((Block)ModBlocks.PALEO_BALE_FERN.get());
        this.m_124288_((Block)ModBlocks.PALEO_BALE_LEAVES.get());
        this.m_124288_((Block)ModBlocks.PALEO_BALE_OTHER.get());
        this.m_124288_((Block)ModBlocks.PEAT.get());
        this.m_124288_((Block)ModBlocks.PEAT_MOSS.get());
        this.m_124147_((Block)ModBlocks.PLANKTON_SWARM.get(), (ItemLike)ModItems.PLANKTON.get());
        this.m_124175_((Block)ModBlocks.REINFORCED_DOOR.get(), BlockLoot::m_124137_);
        this.m_124288_((Block)ModBlocks.REINFORCED_BRICKS.get());
        this.m_124288_((Block)ModBlocks.REINFORCED_STONE_PATHWAY.get());
        this.m_124288_((Block)ModBlocks.REINFORCED_STONE.get());
        this.m_124288_((Block)ModBlocks.REINFORCED_STONE_PANEL.get());
        this.m_124288_((Block)ModBlocks.REINFORCED_STONE_TILES.get());
        this.m_124288_((Block)ModBlocks.REFINED_GYPSUM_PANEL.get());
        this.m_124175_((Block)ModBlocks.SECURITY_DOOR.get(), BlockLoot::m_124137_);
        this.m_124288_((Block)ModBlocks.TOUR_RAIL.get());
        this.m_124288_((Block)ModBlocks.TOUR_RAIL_SLOW.get());
        this.m_124288_((Block)ModBlocks.TOUR_RAIL_MEDIUM.get());
        this.m_124288_((Block)ModBlocks.TOUR_RAIL_FAST.get());
        this.m_124288_((Block)WoodBlocks.ARAUCARIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.CALAMITES_LOG.get());
        this.m_124288_((Block)WoodBlocks.GINKGO_LOG.get());
        this.m_124288_((Block)WoodBlocks.MAGNOLIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.PHOENIX_LOG.get());
        this.m_124288_((Block)WoodBlocks.PSARONIUS_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_ARAUCARIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_CALAMITES_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_GINKGO_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_MAGNOLIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_PHOENIX_LOG.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_PSARONIUS_LOG.get());
        this.m_124288_((Block)WoodBlocks.ARAUCARIA_WOOD.get());
        this.m_124288_((Block)WoodBlocks.CALAMITES_WOOD.get());
        this.m_124288_((Block)WoodBlocks.GINKGO_WOOD.get());
        this.m_124288_((Block)WoodBlocks.MAGNOLIA_WOOD.get());
        this.m_124288_((Block)WoodBlocks.PHOENIX_WOOD.get());
        this.m_124288_((Block)WoodBlocks.PSARONIUS_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_ARAUCARIA_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_CALAMITES_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_GINKGO_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_MAGNOLIA_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_PHOENIX_WOOD.get());
        this.m_124288_((Block)WoodBlocks.STRIPPED_PSARONIUS_WOOD.get());
        this.m_124175_((Block)WoodBlocks.ARAUCARIA_LEAVES.get(), block -> JRBlockLoot.m_124157_((Block)block, (Block)((Block)ModBlocks.ARAUCARIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        this.m_124175_((Block)WoodBlocks.CALAMITES_LEAVES.get(), block -> JRBlockLoot.m_124157_((Block)block, (Block)((Block)ModBlocks.CALAMITES_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        this.m_124175_((Block)WoodBlocks.GINKGO_LEAVES.get(), block -> JRBlockLoot.m_124157_((Block)block, (Block)((Block)ModBlocks.GINKGO_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        this.m_124175_((Block)WoodBlocks.MAGNOLIA_LEAVES.get(), block -> JRBlockLoot.m_124157_((Block)block, (Block)((Block)ModBlocks.MAGNOLIA_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        this.m_124175_((Block)WoodBlocks.PHOENIX_LEAVES.get(), block -> this.createPhoenixLeavesDrops((Block)block, (Block)ModBlocks.PHOENIX_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.m_124175_((Block)WoodBlocks.PSARONIUS_LEAVES.get(), block -> JRBlockLoot.m_124157_((Block)block, (Block)((Block)ModBlocks.PSARONIUS_SAPLING.get()), (float[])NORMAL_LEAVES_SAPLING_CHANCES));
        ModBlockFamilies.getAllFamilies().forEach(family -> {
            Block trapdoor;
            Block door;
            Block sign;
            Block stairs;
            Block slab;
            Block plate;
            Block wall;
            Block gate;
            Block fence;
            this.m_124288_(family.m_175951_());
            Block button = family.m_175952_(BlockFamily.Variant.BUTTON);
            if (button != null) {
                this.m_124288_(button);
            }
            if ((fence = family.m_175952_(BlockFamily.Variant.FENCE)) != null) {
                this.m_124288_(fence);
            }
            if ((gate = family.m_175952_(BlockFamily.Variant.FENCE_GATE)) != null) {
                this.m_124288_(gate);
            }
            if ((wall = family.m_175952_(BlockFamily.Variant.WALL)) != null) {
                this.m_124288_(wall);
            }
            if ((plate = family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE)) != null) {
                this.m_124288_(plate);
            }
            if ((slab = family.m_175952_(BlockFamily.Variant.SLAB)) != null) {
                this.m_124175_(slab, x$0 -> BlockLoot.m_124290_((Block)x$0));
            }
            if ((stairs = family.m_175952_(BlockFamily.Variant.STAIRS)) != null) {
                this.m_124288_(stairs);
            }
            if ((sign = family.m_175952_(BlockFamily.Variant.SIGN)) != null) {
                this.m_124288_(sign);
            }
            if ((door = family.m_175952_(BlockFamily.Variant.DOOR)) != null) {
                this.m_124175_(door, BlockLoot::m_124137_);
            }
            if ((trapdoor = family.m_175952_(BlockFamily.Variant.TRAPDOOR)) != null) {
                this.m_124288_(trapdoor);
            }
        });
        this.m_124288_((Block)WoodBlocks.PETRIFIED_ARAUCARIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.PETRIFIED_CALAMITES_LOG.get());
        this.m_124288_((Block)WoodBlocks.PETRIFIED_GINKGO_LOG.get());
        this.m_124288_((Block)WoodBlocks.PETRIFIED_MAGNOLIA_LOG.get());
        this.m_124288_((Block)WoodBlocks.PETRIFIED_PHOENIX_LOG.get());
        this.m_124288_((Block)WoodBlocks.PETRIFIED_PSARONIUS_LOG.get());
    }

    private LootTable.Builder createPhoenixLeavesDrops(Block leavesBlock, Block sapling, float ... saplingChances) {
        return JRBlockLoot.m_124157_((Block)leavesBlock, (Block)sapling, (float[])saplingChances).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS)))).m_6509_(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))).m_79076_((LootPoolEntryContainer.Builder)JRBlockLoot.m_124131_((ItemLike)leavesBlock, (FunctionUserBuilder)((FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PHOENIX_FRUIT.get())).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.1f))))));
    }

    protected static LootTable.Builder createMultiItemTable(ItemLike ... items) {
        LootPool.Builder builder = LootPool.m_79043_();
        for (ItemLike itemLike : items) {
            builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike));
        }
        return LootTable.m_79147_().m_79161_(builder.m_6509_(ExplosionCondition.m_81661_()));
    }

    protected Iterable<Block> getKnownBlocks() {
        Set<RegistryObject<NestFossilBlock>> exclude = Set.of(ModBlocks.AMBER_ORE, ModBlocks.DEEPSLATE_AMBER_ORE, ModBlocks.DEEPSLATE_ICE_SHARD_ORE, ModBlocks.ICE_SHARD_ORE, ModBlocks.NEST_FOSSIL);
        return ModBlocks.MOD_BLOCKS.getEntries().stream().filter(blockRegistryObject -> !exclude.contains(blockRegistryObject)).map(RegistryObject::get).toList();
    }
}

