/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.AmphibianDinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;

public abstract class CrocodileDinosaurEntity
extends AmphibianDinosaurEntity {
    private static final int DEATH_ROLL_COOLDOWN_T = 100;
    private static final float DEATH_ROLL_DOT_DAMAGE = 2.0f;
    private static final int BASKING_RAND = 500;
    private static final float AMBUSH_STEALTH_MULT = 0.6f;
    private static final float AMBUSH_LUNGE_MULT = 1.6f;
    private static final double AMBUSH_TRIGGER_DIST = 4.0;
    private static final float TAIL_SWEEP_KNOCKBACK = 1.2f;
    private static final float TAIL_SWEEP_CHANCE = 0.25f;
    private static final int TAIL_SWEEP_COOLDOWN_T = 60;
    private int deathRollCooldown = 0;
    private int tailSweepCooldown = 0;

    public CrocodileDinosaurEntity(Level world, EntityType<?> type, Dinosaur dino) {
        super(world, (EntityType)type, dino);
    }

    private boolean isBaskingNow() {
        return !this.f_19853_.f_46443_ ? this.getAnimation() == EntityAnimation.BASKING.get() && !this.m_20069_() && this.f_19861_ && this.m_5448_() == null : this.getAnimation() == EntityAnimation.BASKING.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.deathRollCooldown > 0) {
            --this.deathRollCooldown;
        }
        if (this.tailSweepCooldown > 0) {
            --this.tailSweepCooldown;
        }
        if (!this.f_19853_.f_46443_ && this.getAnimation() == EntityAnimation.BASKING.get() && this.f_19797_ % 80 == 0) {
            this.m_5496_(SoundEvents.f_12530_, 0.15f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == EntityAnimation.BASKING.get() && (this.m_5448_() != null || this.m_20069_() || !this.f_19861_ || this.f_20916_ > 0)) {
            this.setAnimation(EntityAnimation.IDLE.get());
        }
        if (this.isBaskingNow()) {
            this.m_21573_().m_26573_();
            this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
            this.m_7910_(0.0f);
            this.m_21564_(0.0f);
            this.m_21570_(0.0f);
            this.m_21567_(0.0f);
            this.m_6858_(false);
            this.f_20899_ = false;
            Vec3 v = this.m_20184_();
            this.m_20334_(v.f_82479_ * 0.0, v.f_82480_, v.f_82481_ * 0.0);
            this.f_19812_ = false;
            this.m_21563_().m_24946_(this.m_20185_(), this.m_20188_(), this.m_20189_());
        }
        if (!this.f_19853_.f_46443_ && this.m_20069_() && this.getAnimation() == EntityAnimation.DEATH_ROLL.get() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.f_19797_ % 20 == 0) {
            this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
            Vec3 push = this.m_20154_().m_82490_(0.15).m_82520_(0.0, 0.02, 0.0);
            this.m_5448_().m_20256_(this.m_5448_().m_20184_().m_82549_(push));
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && !this.m_20069_() && this.f_19861_ && this.getAnimation() == EntityAnimation.IDLE.get()) {
            boolean bright;
            boolean canSeeSky = this.f_19853_.m_45527_(this.m_142538_());
            int sky = this.f_19853_.m_45517_(LightLayer.SKY, this.m_142538_());
            boolean bl = bright = sky > 10;
            if (canSeeSky && bright && this.f_19796_.nextInt(500) == 0) {
                this.setAnimation(EntityAnimation.BASKING.get());
                this.m_5496_(SoundEvents.f_12486_, 0.2f, 0.9f + this.f_19796_.nextFloat() * 0.2f);
            }
        }
    }

    @Override
    public void m_7023_(Vec3 input) {
        if (this.isBaskingNow()) {
            return;
        }
        if (this.m_20069_() && this.m_5448_() != null) {
            double base;
            double distance = this.m_20270_((Entity)this.m_5448_());
            double d = base = this.m_21051_(Attributes.f_22279_) != null ? this.m_21051_(Attributes.f_22279_).m_22135_() : 0.1;
            if (distance < 4.0) {
                this.m_7910_((float)(base * (double)1.6f));
                if (this.f_19853_.f_46443_ && this.f_19797_ % 10 == 0) {
                    this.m_5496_(SoundEvents.f_12279_, 0.25f, 0.9f + this.f_19796_.nextFloat() * 0.2f);
                }
            } else {
                this.m_7910_((float)(base * (double)0.6f));
            }
        }
        super.m_7023_(input);
    }

    @Override
    public boolean m_7327_(Entity target) {
        boolean flag = super.m_7327_(target);
        if (!flag) {
            return false;
        }
        if (this.m_20069_() && this.deathRollCooldown == 0) {
            this.setAnimation(EntityAnimation.DEATH_ROLL.get());
            this.deathRollCooldown = 100;
            this.m_5496_(SoundEvents.f_11801_, 0.6f, 0.7f + this.f_19796_.nextFloat() * 0.4f);
        } else if (!this.m_20069_() && this.tailSweepCooldown == 0 && this.f_19796_.nextFloat() < 0.25f) {
            this.setAnimation(EntityAnimation.TAIL_SWEEP.get());
            this.tailSweepCooldown = 60;
            double dx = this.m_20185_() - target.m_20185_();
            double dz = this.m_20189_() - target.m_20189_();
            double n = Math.sqrt(dx * dx + dz * dz);
            if (n > 1.0E-4) {
                target.m_5997_((dx /= n) * (double)1.2f, 0.1, (dz /= n) * (double)1.2f);
            }
            this.m_5496_(SoundEvents.f_12562_, 0.4f, 0.8f + this.f_19796_.nextFloat() * 0.3f);
        }
        return true;
    }

    public void m_5997_(double x, double y, double z) {
        if (this.isBaskingNow()) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public boolean m_6094_() {
        return !this.isBaskingNow() && super.m_6094_();
    }
}

