/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class StyracosaurusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(StyracosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static boolean isKingSet = false;
    private boolean isKing = false;
    private StyracosaurusEntity king = null;

    public StyracosaurusEntity(EntityType<StyracosaurusEntity> type, Level world) {
        super(world, type, DinosaurHandler.STYRACOSAURUS);
        this.addTask(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.setVariant(this.m_21187_().nextInt(3));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.STYRACOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.STYRACOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.STYRACOSAURUS_HURT;
            }
            case CALLING: {
                return SoundHandler.STYRACOSAURUS_CALL;
            }
            case ROARING: {
                return SoundHandler.STYRACOSAURUS_ROAR;
            }
            case BEGGING: {
                return SoundHandler.STYRACOSAURUS_THREAT;
            }
        }
        return null;
    }

    @Override
    public void m_8107_() {
        double distance2 = 18.0;
        Entity entityFound2 = null;
        double d4 = -1.0;
        for (Entity e : this.f_19853_.m_45976_(StyracosaurusEntity.class, this.m_142469_().m_82400_(distance2 * distance2))) {
            if (!((double)e.m_20270_((Entity)this) < distance2 * distance2)) continue;
            entityFound2 = e;
            break;
        }
        if (entityFound2 != null && !isKingSet) {
            this.king = (StyracosaurusEntity)entityFound2;
            this.king.isKing = true;
            isKingSet = true;
        }
        if (this.king == null) {
            isKingSet = false;
        }
        if (!this.isKing && isKingSet) {
            this.f_21342_.m_6849_(this.king.m_20185_(), this.king.m_20186_(), this.king.m_20189_(), 1.0);
        }
        super.m_8107_();
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("black");
            }
            case 1: {
                return this.texture("gray");
            }
            case 2: 
        }
        return this.texture("jpog");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }
}

