/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DinosaurLookHelper
extends LookControl {
    private final DinosaurEntity dino;
    private float yawSpeedDeg;
    private float pitchSpeedDeg;
    private boolean hasTarget;
    private double lookX;
    private double lookY;
    private double lookZ;

    public DinosaurLookHelper(DinosaurEntity dino) {
        super((Mob)dino);
        this.dino = dino;
    }

    public void m_24960_(Entity target, float yawSpeed, float pitchSpeed) {
        if (target == null) {
            return;
        }
        this.lookX = target.m_20185_();
        this.lookY = target instanceof LivingEntity ? target.m_20188_() : (target.m_142469_().f_82289_ + target.m_142469_().f_82292_) * 0.5;
        this.lookZ = target.m_20189_();
        this.yawSpeedDeg = yawSpeed;
        this.pitchSpeedDeg = pitchSpeed;
        this.hasTarget = true;
    }

    public void m_24950_(double x, double y, double z, float yawSpeed, float pitchSpeed) {
        this.lookX = x;
        this.lookY = y;
        this.lookZ = z;
        this.yawSpeedDeg = yawSpeed;
        this.pitchSpeedDeg = pitchSpeed;
        this.hasTarget = true;
    }

    public void m_8128_() {
        if (this.hasTarget) {
            this.hasTarget = false;
            double dx = this.lookX - this.dino.m_20185_();
            double dy = this.lookY - this.dino.m_20188_();
            double dz = this.lookZ - this.dino.m_20189_();
            double horiz = Math.sqrt(dx * dx + dz * dz);
            float desiredYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float desiredPitch = (float)(-(Mth.m_14136_((double)dy, (double)horiz) * 57.29577951308232));
            float newHeadYaw = DinosaurLookHelper.rotateToward(this.dino.m_6080_(), desiredYaw, this.yawSpeedDeg);
            float newHeadPitch = DinosaurLookHelper.rotateToward(this.dino.m_146909_(), desiredPitch, this.pitchSpeedDeg);
            float maxHeadYaw = this.dino.m_8085_();
            float maxHeadPitch = this.dino.m_8132_();
            float clampedYaw = DinosaurLookHelper.clampHeadYawRelativeToBody(newHeadYaw, this.dino.f_20883_, maxHeadYaw);
            float clampedPitch = Mth.m_14036_((float)newHeadPitch, (float)(-maxHeadPitch), (float)maxHeadPitch);
            this.dino.m_5616_(clampedYaw);
            this.dino.m_146926_(clampedPitch);
        } else {
            float eased = DinosaurLookHelper.rotateToward(this.dino.m_6080_(), this.dino.f_20883_, 10.0f);
            this.dino.m_5616_(eased);
        }
    }

    private static float rotateToward(float current, float target, float maxStep) {
        float delta = Mth.m_14177_((float)(target - current));
        delta = Mth.m_14036_((float)delta, (float)(-maxStep), (float)maxStep);
        return current + delta;
    }

    private static float clampHeadYawRelativeToBody(float headYaw, float bodyYaw, float maxDeltaFromBody) {
        float diff = Mth.m_14177_((float)(headYaw - bodyYaw));
        diff = Mth.m_14036_((float)diff, (float)(-maxDeltaFromBody), (float)maxDeltaFromBody);
        return bodyYaw + diff;
    }

    public double m_24969_() {
        return this.lookX;
    }

    public double m_24970_() {
        return this.lookY;
    }

    public double m_24971_() {
        return this.lookZ;
    }
}

