/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CalymeneEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CalymeneDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.15f;

    public CalymeneDinosaur() {
        this.setName("Calymene");
        this.setScientificName("Calymene blumenbachii");
        this.setFamily("Calymenidae");
        this.setLocation("Europe");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(CalymeneEntity.class);
        this.setTimePeriod(TimePeriod.SILURIAN);
        this.setEggColorMale(0x7C7C7A, 0x262626);
        this.setEggColorFemale(0x7C7C7B, 0x262629);
        this.setHealth(2.0, 5.0);
        this.setSpeed(0.15f, 0.15f);
        this.setStrength(0.5, 1.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.02f, 0.05f);
        this.setSizeX(0.1f, 0.3f);
        this.setSizeY(0.2f, 0.3f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("cephalon", "thorax", "pygidium");
        this.setHeadCubeName("Head");
        this.setScale(0.1f, 0.05f);
        this.setBirthType(Dinosaur.BirthType.EGG_LAYING);
        this.setAttackBias(1.0);
        this.setImprintable(false);
        this.setBreeding(false, 6, 16, 20, false, true);
        this.setMarineAnimal(true);
        String[][] recipe = new String[][]{{"cephalon"}, {"thorax"}, {"pygidium"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

