/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DimorphodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DimorphodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public DimorphodonDinosaur() {
        this.setName("Dimorphodon");
        this.setScientificName("Dimorphodon macronyx");
        this.setFamily("Dimorphodontidae");
        this.setLocation("United Kingdom");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(DimorphodonEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(11709588, 0x636644);
        this.setEggColorFemale(12432553, 7498583);
        this.setHealth(6.0, 12.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(35));
        this.setAttackBias(80.0);
        this.setEyeHeight(0.3f, 0.9f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.0f);
        this.setStorage(9);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setBones("leg_bones", "neck", "ribs_and_spine", "shoulder_blade", "skull", "tail_vertebrae", "teeth", "wing_bones");
        this.setHeadCubeName("Head");
        this.setImprintable(true);
        this.setAvianAnimal(true);
        this.setStorage(12);
        this.setScale(0.5f, 0.15f);
        this.setBreeding(false, 2, 6, 80, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck", "skull"}, {"tail_vertebrae", "ribs_and_spine", "shoulder_blade", "", "teeth"}, {"", "leg_bones", "wing_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, BiomeTags.f_207610_, BiomeTags.f_207606_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

