/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class HypsilophodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.35f;

    public HypsilophodonDinosaur() {
        this.setName("Hypsilophodon");
        this.setScientificName("Hypsilophodon foxii");
        this.setFamily("Hypsilophodontidae");
        this.setLocation("England");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(HypsilophodonEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(8236152, 4088358);
        this.setEggColorFemale(7966835, 3359535);
        this.setHealth(4.0, 16.0);
        this.setSpeed(0.24999999403953552, 0.35f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(35));
        this.setEyeHeight(0.2f, 0.8f);
        this.setSizeX(0.2f, 0.6f);
        this.setSizeY(0.25f, 0.85f);
        this.setStorage(9);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("arm_bones", "leg_bones", "neck_vertebrae", "tail_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tooth", "arm_bones");
        this.setHeadCubeName("Head ");
        this.setBreeding(false, 2, 6, 22, false, true);
        this.setAttackBias(-50.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setScale(0.65f, 0.1f);
        String[][] recipe = new String[][]{{"", "pelvis", "", "", ""}, {"tail_vertebrae", "ribcage", "shoulder", "neck_vertebrae", "skull"}, {"leg_bones", "", "", "arm_bones", "tooth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207592_, Tags.Biomes.IS_CONIFEROUS, BiomeTags.f_207607_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

