/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LudodactylusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class LudodactylusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public LudodactylusDinosaur() {
        this.setName("Ludodactylus");
        this.setScientificName("Ludodactylus sibbicki");
        this.setFamily("Anhangueridae");
        this.setLocation("Brazil");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(LudodactylusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(0x565656, 1908256);
        this.setEggColorFemale(8932670, 3485739);
        this.setHealth(4.0, 26.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(3.0, 10.0);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.3f, 1.25f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.35f);
        this.setStorage(18);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("leg_bones", "pelvis", "skull", "ribcage", "tail_vertebrae", "teeth", "wing_bones");
        this.setHeadCubeName("Head");
        this.setScale(0.8f, 0.1f);
        this.shouldDefendOffspring();
        this.setAttackBias(120.0);
        this.setImprintable(true);
        this.setAvianAnimal(true);
        this.setBreeding(false, 2, 6, 80, false, true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "skull", "teeth"}, {"", "leg_bones", "wing_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207592_, BiomeTags.f_207607_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

