/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MosasaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MosasaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.45f;

    public MosasaurusDinosaur() {
        this.setName("Mosasaurus");
        this.setScientificName("Mosasaurus maximus");
        this.setFamily("Mosasauridae");
        this.setLocation("Netherlands");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(MosasaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(8286807, 4800814);
        this.setEggColorFemale(6193286, 5008240);
        this.setHealth(20.0, 150.0);
        this.setSpeed(0.19999998807907104, 0.45f);
        this.setStrength(20.0, 50.0);
        this.setMaximumAge(this.fromDays(70));
        this.setMarineAnimal(true);
        this.setEyeHeight(0.225f, 3.5f);
        this.setSizeX(1.8f, 3.6f);
        this.setSizeY(1.0f, 3.6f);
        this.setStorage(27);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setBones("front_flipper", "hind_flipper", "inner_teeth", "ribcage", "skull", "spine", "tail_fluke", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Main head");
        this.setScale(4.0f, 0.2f);
        this.setMarineAnimal(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setAttackBias(1200.0);
        this.setAttackSpeed(2.0);
        this.setStorage(12);
        this.setPaleoPadScale(3.0f);
        this.setImprintable(false);
        this.setBreeding(true, 1, 3, 80, false, true);
        String[][] recipe = new String[][]{{"tail_fluke", "tail_vertebrae", "spine", "ribcage", "skull"}, {"hind_flipper", "", "front_flipper", "inner_teeth", "tooth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        this.setOffset(0.0f, 1.0f, 0.0f);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207603_, Tags.Biomes.IS_WATER};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }
}

