/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OviraptorEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class OviraptorDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public OviraptorDinosaur() {
        this.setName("Oviraptor");
        this.setScientificName("Oviraptor philoceratops");
        this.setFamily("Oviraptoridae");
        this.setLocation("Mongolia");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(OviraptorEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(9377064, 5002597);
        this.setEggColorFemale(156186, 13815043);
        this.setHealth(4.0, 16.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStorage(9);
        this.setAttackSpeed(1.11);
        this.setStrength(2.0, 4.0);
        this.setMaximumAge(this.fromDays(25));
        this.setEyeHeight(0.25f, 0.9f);
        this.setSizeX(0.25f, 0.6f);
        this.setSizeY(0.32f, 0.95f);
        this.setMaxHerdSize(8);
        this.setDiet(Diet.CARNIVORE.get().withModule(new Diet.DietModule(FoodType.PLANT)).withModule(new Diet.DietModule(FoodType.MEAT).withCondition(entity -> entity instanceof CompsognathusEntity || entity instanceof MicroraptorEntity)));
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBones("arm_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae");
        this.setHeadCubeName("Upper Head");
        this.setAttackBias(5.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setScale(0.4f, 0.09f);
        this.setBreeding(false, 2, 4, 30, false, true);
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder"}, {"", "leg_bones", "", "arm_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_SANDY, Tags.Biomes.IS_DRY, BiomeTags.f_207592_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

