/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.QuetzalEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class QuetzalDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public QuetzalDinosaur() {
        this.setName("Quetzalcoatlus");
        this.setScientificName("Quetzalcoatlus northropi");
        this.setFamily("Azhdarchidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(QuetzalEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(9277323, 1846592);
        this.setEggColorFemale(9277323, 3022874);
        this.setHealth(10.0, 30.0);
        this.setStrength(2.0, 10.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.55f, 2.9f);
        this.setSizeX(0.8f, 2.4f);
        this.setSizeY(0.6f, 3.0f);
        this.setStorage(27);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("skull", "ribcage", "leg_bones", "neck_vertebrae", "pelvis", "tail_vertebrae", "wing_bones");
        this.setHeadCubeName("Head");
        this.setScale(2.4f, 0.15f);
        this.setAttackBias(1200.0);
        this.shouldDefendOffspring();
        this.setBreeding(false, 1, 4, 80, false, true);
        this.enableSkeleton();
        this.setAvianAnimal(true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "", ""}, {"", "leg_bones", "", "wing_bones", ""}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, BiomeTags.f_207610_, BiomeTags.f_207606_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

