/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class InventoryDinosaur
implements Container {
    private DinosaurEntity entity;
    private NonNullList<ItemStack> inventory;
    private ArrayList<Item> ITEMS = new ArrayList();

    public InventoryDinosaur(DinosaurEntity entity) {
        this.entity = entity;
        this.inventory = NonNullList.m_122780_((int)entity.getDinosaur().getStorage(), (Object)ItemStack.f_41583_);
    }

    public void writeToNBT(CompoundTag nbt) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.inventory.size(); ++i) {
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).m_41739_(slotTag);
            nbttaglist.add((Object)slotTag);
        }
        nbt.m_128365_("Items", (Tag)nbttaglist);
    }

    public void readFromNBT(CompoundTag nbt) {
        ListTag nbttaglist = nbt.m_128437_("Items", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag slotTag = nbttaglist.m_128728_(i);
            ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(slotTag.m_128461_("id"))), (int)slotTag.m_128445_("Count"), slotTag.m_128441_("tag") ? slotTag.m_128469_("tag") : new CompoundTag());
            int j = slotTag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.size()) continue;
            this.m_6836_(j, stack);
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int index) {
        if (!this.inventory.isEmpty() && index < this.inventory.size()) {
            return (ItemStack)this.inventory.get(index);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).m_41619_()) {
            if (((ItemStack)this.inventory.get(index)).m_41613_() <= count) {
                ItemStack itemstack = (ItemStack)this.inventory.get(index);
                this.m_6836_(index, ItemStack.f_41583_);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(index)).m_41620_(count);
            if (((ItemStack)this.inventory.get(index)).m_41613_() == 0) {
                this.m_6836_(index, ItemStack.f_41583_);
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        this.m_6836_(index, ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        this.ITEMS.add(stack.m_41720_());
        if (!stack.m_41619_() && stack.m_41613_() > this.getInventorySize()) {
            stack.m_41764_(this.getInventorySize());
        }
    }

    public boolean contains(Item item) {
        if (this.ITEMS.isEmpty()) {
            return false;
        }
        return this.ITEMS.contains(item);
    }

    public int getInventorySize() {
        return 64;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return !this.entity.m_21224_() && player.m_20280_((Entity)this.entity) <= 64.0;
    }

    public void openInventory(Player player) {
    }

    public void closeInventory(Player player) {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public String getName() {
        return this.entity.m_7755_().getString();
    }

    public boolean hasCustomName() {
        return this.entity.m_8077_();
    }

    public Component getDisplayName() {
        return this.entity.m_5446_();
    }

    public void dropItems(Level world, Random rand) {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            float offsetX = rand.nextFloat() * 0.8f + 0.1f;
            float offsetY = rand.nextFloat() * 0.8f + 0.1f;
            float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity itemEntity = new ItemEntity(world, this.entity.m_20185_() + (double)offsetX, this.entity.m_20186_() + (double)offsetY, this.entity.m_20189_() + (double)offsetZ, new ItemStack((ItemLike)itemstack.m_41720_(), itemstack.m_41613_(), itemstack.m_41783_()));
            float multiplier = 0.05f;
            itemEntity.m_20334_((double)((float)rand.nextGaussian() * multiplier), (double)((float)rand.nextGaussian() * multiplier + 0.2f), (double)((float)rand.nextGaussian() * multiplier));
            world.m_7967_((Entity)itemEntity);
            itemstack.m_41774_(itemstack.m_41613_());
        }
    }

    public void dropItems(Level world, RandomSource rand) {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            float offsetX = rand.nextFloat() * 0.8f + 0.1f;
            float offsetY = rand.nextFloat() * 0.8f + 0.1f;
            float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity itemEntity = new ItemEntity(world, this.entity.m_20185_() + (double)offsetX, this.entity.m_20186_() + (double)offsetY, this.entity.m_20189_() + (double)offsetZ, new ItemStack((ItemLike)itemstack.m_41720_(), itemstack.m_41613_(), itemstack.m_41783_()));
            float multiplier = 0.05f;
            itemEntity.m_20334_((double)((float)rand.nextGaussian() * multiplier), (double)((float)rand.nextGaussian() * multiplier + 0.2f), (double)((float)rand.nextGaussian() * multiplier));
            world.m_7967_((Entity)itemEntity);
            itemstack.m_41774_(itemstack.m_41613_());
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean m_7983_() {
        return false;
    }
}

