/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DinosaurAttributes {
    private static final float MINIMUM_SCALE = 0.8f;
    private static final float MAXIMUM_SCALE = 1.2f;
    private static final float RARE_SCALE = 1.4f;
    private static final float MINIMUM_DAMAGE = 0.8f;
    private static final float MAXIMUM_DAMAGE = 1.2f;
    private static final float MINIMUM_HEALTH = 0.8f;
    private static final float MAXIMUM_HEALTH = 1.2f;
    private static final float MINIMUM_SPEED = 0.8f;
    private static final float MAXIMUM_SPEED = 1.0f;
    private float scaleModifier;
    private float damageModifier;
    private float healthModifier;
    private float speedModifier;

    private DinosaurAttributes(float scaleModifier, float damageModifier, float healthModifier, float speedModifier) {
        this.scaleModifier = scaleModifier;
        this.damageModifier = damageModifier;
        this.healthModifier = healthModifier;
        this.speedModifier = speedModifier;
    }

    public void writeToNBT(CompoundTag compound) {
        compound.m_128350_("Scale", this.scaleModifier);
        compound.m_128350_("Damage", this.damageModifier);
        compound.m_128350_("Health", this.healthModifier);
        compound.m_128350_("Speed", this.speedModifier);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.scaleModifier);
        buf.writeFloat(this.damageModifier);
        buf.writeFloat(this.healthModifier);
        buf.writeFloat(this.speedModifier);
    }

    public static DinosaurAttributes combine(DinosaurEntity entity, DinosaurAttributes attributes1, DinosaurAttributes attributes2) {
        Random random = entity.m_21187_();
        float scale = DinosaurAttributes.random(random, attributes1.scaleModifier, attributes2.scaleModifier);
        if (random.nextInt(3) == 0) {
            scale = DinosaurAttributes.random(random, 0.8f, 1.2f);
        }
        float scaleStat = (2.0f + scale) / 3.0f;
        float damage = DinosaurAttributes.random(random, attributes1.damageModifier, attributes2.damageModifier);
        if (random.nextInt(3) == 0) {
            damage = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        }
        float health = DinosaurAttributes.random(random, attributes1.healthModifier, attributes2.healthModifier);
        if (random.nextInt(3) == 0) {
            health = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        }
        float speed = DinosaurAttributes.random(random, attributes1.speedModifier, attributes2.speedModifier);
        if (random.nextInt(3) == 0) {
            speed = DinosaurAttributes.random(random, 0.8f, 1.0f) / scaleStat;
        }
        return new DinosaurAttributes(scale, damage, health, speed);
    }

    public static DinosaurAttributes create(DinosaurEntity entity) {
        Random random = entity.m_21187_();
        float scale = DinosaurAttributes.random(random, 0.8f, 1.2f);
        float scaleStat = (2.0f + scale) / 3.0f;
        float damage = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        float health = DinosaurAttributes.random(random, 0.8f, 1.2f) * scaleStat;
        float speed = DinosaurAttributes.random(random, 0.8f, 1.0f) / scaleStat;
        return new DinosaurAttributes(scale, damage, health, speed);
    }

    public static DinosaurAttributes from(CompoundTag compound) {
        float scaleModifier = compound.m_128457_("Scale");
        float damageModifier = compound.m_128457_("Damage");
        float healthModifier = compound.m_128457_("Health");
        float speedModifier = compound.m_128457_("Speed");
        return new DinosaurAttributes(scaleModifier, damageModifier, healthModifier, speedModifier);
    }

    public static DinosaurAttributes from(FriendlyByteBuf buf) {
        float scale = buf.readFloat();
        float damage = buf.readFloat();
        float health = buf.readFloat();
        float speed = buf.readFloat();
        return new DinosaurAttributes(scale, damage, health, speed);
    }

    private static float random(Random random, float v1, float v2) {
        float minimum = Math.min(v1, v2);
        float maximum = Math.max(v1, v2);
        float range = maximum - minimum;
        return (float)(random.nextDouble() * (double)range + (double)minimum);
    }

    private static float random(Random random, float v1, float v2, float v3) {
        float minimum = Math.min(v1, v2);
        float maximum = Math.max(v1, v2);
        float range = maximum - minimum;
        return (float)(random.nextDouble() * (double)range + (double)minimum);
    }

    public float getScaleModifier() {
        return this.scaleModifier;
    }

    public float getHealthModifier() {
        return this.healthModifier;
    }

    public float getDamageModifier() {
        return this.damageModifier;
    }

    public float getSpeedModifier() {
        return this.speedModifier;
    }

    public void setScaleModifier(float scaleModifier) {
        this.scaleModifier = scaleModifier;
    }
}

