/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.FlyingDinosaurEntity;
import net.vit.jurassicreborn.common.entities.ai.util.AIUtils;

public class SleepEntityAI
extends Goal {
    private final DinosaurEntity dino;
    private Path path;
    private int giveUpTicks;

    public SleepEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        BlockPos shore;
        FlyingDinosaurEntity flying;
        Level level = this.dino.f_19853_;
        if (this.dino.getMetabolism().isHungry()) {
            return false;
        }
        boolean marine = this.dino.getDinosaur().isMarineCreature();
        if (!this.dino.m_6084_() || this.dino.m_5803_() || !this.dino.shouldSleep() || this.dino.getStayAwakeTime() > 0) {
            return false;
        }
        DinosaurEntity dinosaurEntity = this.dino;
        if (dinosaurEntity instanceof FlyingDinosaurEntity && !(flying = (FlyingDinosaurEntity)dinosaurEntity).m_20096_()) {
            flying.shouldLand = true;
            return false;
        }
        if (marine) {
            return true;
        }
        int RANGE = 8;
        int ox = (int)this.dino.m_20185_();
        int oz = (int)this.dino.m_20189_();
        for (int x = ox - 8; x <= ox + 8; ++x) {
            for (int z = oz - 8; z <= oz + 8; ++z) {
                BlockPos top = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z));
                if (!level.m_46749_(top) || !level.m_46859_(top) || level.m_6425_(top.m_7495_()).m_205070_(FluidTags.f_13131_) || level.m_45527_(top) || !this.canFit(top) || !this.dino.setSleepLocation(top, true)) continue;
                this.path = this.dino.m_21573_().m_26570_();
                return true;
            }
        }
        if (this.dino.m_20069_() && (shore = AIUtils.findShore(level, this.dino.m_142538_())) != null && this.dino.m_21573_().m_26519_((double)shore.m_123341_() + 0.5, (double)shore.m_123342_(), (double)shore.m_123343_() + 0.5, 1.0)) {
            this.path = this.dino.m_21573_().m_26570_();
            return true;
        }
        BlockPos here = this.dino.m_142538_();
        if (level.m_46749_(here)) {
            this.dino.setSleepLocation(here, false);
            this.path = null;
            return true;
        }
        return false;
    }

    private boolean canFit(BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        double halfWidth = (double)this.dino.m_20205_() / 2.0;
        AABB box = new AABB(x - halfWidth, y, z - halfWidth, x + halfWidth, y + (double)this.dino.m_20206_(), z + halfWidth);
        return this.dino.f_19853_.m_45756_((Entity)this.dino, box);
    }

    public void m_8056_() {
        this.giveUpTicks = 400;
    }

    public void m_8037_() {
        PathNavigation nav = this.dino.m_21573_();
        if (this.path != null) {
            Path newPath;
            Node end = this.path.m_77395_();
            Path current = nav.m_26570_();
            if (!(end == null || current != null && current.m_77395_() != null && SleepEntityAI.sameNode(end, current.m_77395_()) || (newPath = nav.m_26524_((double)end.f_77271_, (double)end.f_77272_, (double)end.f_77273_, 1)) == null)) {
                nav.m_26536_(newPath, 1.0);
                this.path = newPath;
            }
        }
        if (--this.giveUpTicks <= 0 || this.dino.getStayAwakeTime() <= 0 && (this.path == null || this.path.m_77392_())) {
            nav.m_26573_();
            this.dino.setSleeping(true);
        }
    }

    private static boolean sameNode(Node a, Node b) {
        return a.f_77271_ == b.f_77271_ && a.f_77272_ == b.f_77272_ && a.f_77273_ == b.f_77273_;
    }

    public boolean m_8045_() {
        return !this.dino.isCarcass() && !this.dino.m_5803_() && this.dino.shouldSleep();
    }

    public void m_8041_() {
        this.dino.m_21573_().m_26573_();
        this.dino.setSleeping(true);
        this.path = null;
    }
}

