/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.SwimmingDinosaurEntity;

public class WaterLeapAI
extends Goal {
    private static final int[] OFFSET_MULTIPLIERS = new int[]{0, 1, 4, 5, 6, 7};
    private final SwimmingDinosaurEntity entity;
    private final int chance;
    private final float yeetHeight;
    private float jumpHeight;
    private boolean launched = false;
    private int prevTick;
    private EntityAnimation animation;

    public WaterLeapAI(SwimmingDinosaurEntity entity, int chance, float yeetPower) {
        this.entity = entity;
        this.chance = chance;
        this.yeetHeight = yeetPower;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.entity.m_21187_().nextInt(this.chance) != 0) {
            return false;
        }
        if (this.entity.isBusy()) {
            return false;
        }
        if (!this.entity.m_20069_()) {
            return false;
        }
        this.launched = false;
        Direction dir = this.entity.m_6350_();
        int dx = dir.m_122429_();
        int dz = dir.m_122431_();
        BlockPos base = this.entity.m_20097_();
        for (int mult : OFFSET_MULTIPLIERS) {
            if (this.entity.m_20069_() && this.isAirAbove(base, dx, dz, mult)) continue;
            return false;
        }
        return true;
    }

    public boolean m_8045_() {
        return this.launched && this.entity.getAnimation() != EntityAnimation.IDLE.get();
    }

    public void m_8056_() {
        this.animation = EntityAnimation.PREPARE_LEAP;
        this.prevTick = this.entity.getAnimationTick();
    }

    public void m_8037_() {
        int tick = this.entity.getAnimationTick();
        if (this.animation == EntityAnimation.PREPARE_LEAP && tick < this.prevTick) {
            this.animation = EntityAnimation.LEAP;
            Vec3 look = this.entity.m_20154_().m_82541_();
            double hSpeed = 1.8;
            double motionX = look.f_82479_ * hSpeed;
            double motionZ = look.f_82481_ * hSpeed;
            double motionY = this.jumpHeight;
            this.entity.m_5496_(this.entity.getSoundForAnimation(EntityAnimation.LEAP.get()), this.entity.m_6121_(), this.entity.m_6100_());
            this.entity.m_20334_(motionX, motionY, motionZ);
        } else if (this.animation == EntityAnimation.LEAP && this.entity.m_20184_().f_82480_ < 0.0) {
            this.animation = EntityAnimation.LEAP_LAND;
            this.launched = true;
        } else if (this.animation == EntityAnimation.LEAP_LAND && (this.entity.m_20096_() || this.entity.m_6069_())) {
            this.animation = EntityAnimation.IDLE;
        }
        if (this.entity.getAnimation() != this.animation.get()) {
            this.entity.setAnimation(this.animation.get());
            this.entity.setAnimationTick(this.prevTick + 1);
        }
        this.prevTick = tick;
    }

    public void m_8041_() {
        this.entity.setAnimation(EntityAnimation.IDLE.get());
        this.launched = false;
    }

    private boolean isAirAbove(BlockPos pos, int xOffset, int zOffset, int multiplier) {
        for (int y = 1; y <= 4; ++y) {
            BlockPos check = pos.m_142082_(xOffset * multiplier, y, zOffset * multiplier);
            BlockState state = this.entity.f_19853_.m_8055_(check);
            if (!state.m_60795_()) continue;
            this.jumpHeight = this.yeetHeight + ((float)y / 2.0f - 0.5f);
            return true;
        }
        return false;
    }
}

