/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.metabolism;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.MetabolismContainer;
import net.vit.jurassicreborn.common.entities.ai.util.AIUtils;

public class DrinkEntityAI
extends Goal {
    private final DinosaurEntity dino;
    private Path path;
    private BlockPos shore;
    private int giveUpTicks;
    private int drinkCooldown;
    private BlockPos cachedShore;
    private int shoreCacheTick;

    public DrinkEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dino == null || this.dino.isCarcass() || !this.dino.m_6084_()) {
            return false;
        }
        MetabolismContainer meta = this.dino.getMetabolism();
        if (!meta.isThirsty()) {
            return false;
        }
        if (!this.dino.m_21573_().m_26571_()) {
            return false;
        }
        Level level = this.dino.f_19853_;
        BlockPos origin = this.dino.m_142538_();
        if ((this.dino.f_19797_ + this.dino.m_142049_() & 7) != 0) {
            return false;
        }
        if (this.cachedShore == null || this.dino.m_20275_((double)this.cachedShore.m_123341_() + 0.5, (double)this.cachedShore.m_123342_() + 0.5, (double)this.cachedShore.m_123343_() + 0.5) > 2304.0 || this.dino.f_19797_ - this.shoreCacheTick > 80) {
            this.cachedShore = AIUtils.findShore(level, origin);
            this.shoreCacheTick = this.dino.f_19797_;
            for (int i = 0; this.cachedShore == null && i < 6; ++i) {
                BlockPos s;
                int dz;
                int dx = this.dino.m_21187_().nextInt(33) - 16;
                BlockPos sample = origin.m_142082_(dx, 0, dz = this.dino.m_21187_().nextInt(33) - 16);
                if (!level.m_46749_(sample) || (s = AIUtils.findShore(level, sample)) == null || !level.m_46749_(s)) continue;
                this.cachedShore = s;
            }
        }
        if (this.cachedShore == null || !level.m_46749_(this.cachedShore)) {
            return false;
        }
        Path p = this.dino.m_21573_().m_7864_(this.cachedShore, 0);
        if (p == null) {
            return false;
        }
        this.shore = this.cachedShore.m_7949_();
        this.path = p;
        this.dino.m_21573_().m_26536_(p, meta.isDehydrated() ? 1.2 : 0.7);
        int nodes = p.m_77398_();
        this.giveUpTicks = Math.max(80, Math.min(400, nodes * 20));
        this.drinkCooldown = 0;
        return true;
    }

    public void m_8056_() {
    }

    public boolean m_8045_() {
        if (this.dino == null || this.dino.isCarcass() || !this.dino.m_6084_()) {
            return false;
        }
        if (this.shore == null) {
            return false;
        }
        boolean nearShore = this.dino.m_142538_().m_123331_((Vec3i)this.shore) <= 6.0;
        MetabolismContainer m = this.dino.getMetabolism();
        boolean thirsty = (double)m.getWater() < (double)m.getMaxWater() * 0.9;
        boolean enRoute = this.path != null && !this.path.m_77392_();
        return (enRoute || nearShore && thirsty) && this.giveUpTicks > 0;
    }

    public void m_8037_() {
        if (this.shore == null) {
            return;
        }
        Vec3 look = Vec3.m_82512_((Vec3i)this.shore);
        this.dino.m_21563_().m_24950_(look.f_82479_, look.f_82480_, look.f_82481_, 30.0f, (float)this.dino.m_8132_());
        if (this.dino.m_142538_().m_123331_((Vec3i)this.shore) <= 6.0) {
            this.dino.m_21573_().m_26573_();
            this.dino.m_20256_(Vec3.f_82478_);
            this.dino.m_146922_(this.dino.m_6080_());
            this.dino.m_5618_(this.dino.m_6080_());
            this.dino.f_19859_ = this.dino.m_146908_();
            this.dino.f_20884_ = this.dino.f_20883_;
            this.dino.f_20886_ = this.dino.m_6080_();
            if (!this.dino.f_19853_.f_46443_ && this.drinkCooldown-- <= 0) {
                this.dino.setAnimation(EntityAnimation.DRINKING.get());
                MetabolismContainer meta = this.dino.getMetabolism();
                int add = Math.max(50, meta.getMaxWater() / 8);
                meta.setWater(Math.min(meta.getWater() + add, meta.getMaxWater()));
                this.drinkCooldown = 20;
            }
        }
        if (--this.giveUpTicks <= 0) {
            this.m_8041_();
        }
    }

    public void m_8041_() {
        if (this.dino != null) {
            this.dino.m_21573_().m_26573_();
        }
        this.path = null;
        this.shore = null;
        this.drinkCooldown = 0;
        this.giveUpTicks = 0;
    }

    public boolean m_6767_() {
        return false;
    }
}

