/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.item;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.item.WallHangingEntity;
import net.vit.jurassicreborn.common.items.ModItems;

public class MuralEntity
extends WallHangingEntity
implements IEntityAdditionalSpawnData {
    private Type type;

    public MuralEntity(EntityType<? extends MuralEntity> entityType, Level level) {
        super(entityType, level);
        this.type = Type.CREATION_LAB;
        this.f_19811_ = true;
    }

    public MuralEntity(Level level, BlockPos clickedPos, Direction facing, Type type) {
        super((EntityType<? extends WallHangingEntity>)((EntityType)ModEntities.MURAL.get()), level, clickedPos.m_142300_(facing));
        this.type = type;
        this.f_19811_ = true;
        this.m_6022_(facing);
    }

    public Type getMuralType() {
        return this.type;
    }

    public void setMuralType(Type type) {
        this.type = type;
        if (this.f_31699_ != null) {
            this.m_6022_(this.f_31699_);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Type", this.type.ordinal());
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.type = Type.byIndex(tag.m_128451_("Type"));
        if (tag.m_128441_("Facing")) {
            this.m_6022_(Direction.m_122407_((int)tag.m_128445_("Facing")));
        } else if (this.f_31699_ != null) {
            this.m_6022_(this.f_31699_);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeLong(this.m_31748_().m_121878_());
        buf.writeByte(this.f_31699_.m_122416_());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.type = Type.byIndex(buf.readInt());
        this.f_31698_ = BlockPos.m_122022_((long)buf.readLong());
        this.m_6022_(Direction.m_122407_((int)buf.readUnsignedByte()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        block2: {
            block3: {
                if (this.f_19853_.m_5776_() || !this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) break block2;
                if (!(brokenEntity instanceof Player)) break block3;
                Player player = (Player)brokenEntity;
                if (player.m_150110_().f_35937_) break block2;
            }
            this.m_5552_(new ItemStack((ItemLike)ModItems.MURAL.get()), 0.0f);
        }
    }

    public void m_7084_() {
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.MURAL.get());
    }

    public static enum Type {
        BUNKER(128, 64),
        RIVER(64, 48),
        MAMENCHI(64, 64),
        LAB(16, 32),
        JR(16, 16),
        AMBER(16, 16),
        EGG(16, 32),
        CREATION_LAB(64, 32),
        FOSSILS(128, 64),
        HUNT_LEFT(64, 64),
        HUNT_MIDDLE(64, 64),
        HUNT_RIGHT(64, 64),
        MOSASAURUS_1(64, 32),
        PARK_ENTRANCE(64, 32),
        RIDING(64, 32),
        SKETCH(64, 32),
        TRICERATOPS_1(128, 32),
        VALLEY(64, 32),
        JOHN_HAMMOND(32, 32);

        public final int sizeX;
        public final int sizeY;
        public final ResourceLocation texture;

        private Type(int sizeX, int sizeY) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.texture = new ResourceLocation("jurassicreborn", "textures/painting/" + this.name().toLowerCase(Locale.ROOT) + ".png");
        }

        public static Type byIndex(int index) {
            Type[] values = Type.values();
            if (index < 0 || index >= values.length) {
                return values[0];
            }
            return values[index];
        }
    }
}

