/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class WallHangingEntity
extends HangingEntity {
    protected WallHangingEntity(EntityType<? extends WallHangingEntity> type, Level level) {
        super(type, level);
    }

    protected WallHangingEntity(EntityType<? extends WallHangingEntity> type, Level level, BlockPos pos) {
        super(type, level, pos);
    }

    public boolean m_7088_() {
        if (!this.f_19853_.m_45756_((Entity)this, this.m_142469_())) {
            return false;
        }
        Direction facing = this.f_31699_;
        if (facing == null) {
            return false;
        }
        int widthBlocks = Math.max(1, this.m_7076_() / 16);
        int heightBlocks = Math.max(1, this.m_7068_() / 16);
        Direction right = facing.m_122428_();
        BlockPos backingStart = this.f_31698_.m_142300_(facing.m_122424_()).m_5484_(right, -(widthBlocks / 2) + 1);
        for (int x = 0; x < widthBlocks; ++x) {
            for (int y = 0; y < heightBlocks; ++y) {
                BlockPos check = backingStart.m_5484_(right, x).m_6625_(y);
                BlockState state = this.f_19853_.m_8055_(check);
                if (state.m_60659_((BlockGetter)this.f_19853_, check, facing, SupportType.FULL)) continue;
                return false;
            }
        }
        List overlaps = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), this::isSameKind);
        return overlaps.isEmpty();
    }

    protected boolean isSameKind(Entity other) {
        return other.m_6095_() == this.m_6095_();
    }

    protected void m_7087_() {
        Direction facing = this.f_31699_;
        if (facing == null) {
            return;
        }
        double anchorX = (double)this.f_31698_.m_123341_() + 0.5;
        double anchorY = (double)this.f_31698_.m_123342_() + 0.5;
        double anchorZ = (double)this.f_31698_.m_123343_() + 0.5;
        double wallOffset = 0.46875;
        double offsetX = this.offsetForPixels(this.m_7076_());
        double offsetY = this.offsetForPixels(this.m_7068_());
        anchorX -= (double)facing.m_122429_() * wallOffset;
        anchorZ -= (double)facing.m_122431_() * wallOffset;
        anchorY += offsetY;
        Direction right = facing.m_122428_();
        anchorX += offsetX * (double)right.m_122429_();
        anchorZ += offsetX * (double)right.m_122431_();
        double width = this.m_7076_();
        double height = this.m_7068_();
        double depth = this.m_7076_();
        if (facing.m_122434_() == Direction.Axis.Z) {
            depth = 1.0;
        } else {
            width = 1.0;
        }
        this.m_20343_(anchorX, anchorY, anchorZ);
        this.m_20011_(new AABB(anchorX - (width /= 32.0), anchorY - (height /= 32.0), anchorZ - (depth /= 32.0), anchorX + width, anchorY + height, anchorZ + depth));
    }

    private double offsetForPixels(int pixels) {
        return pixels % 32 == 0 ? 0.5 : 0.0;
    }

    public void m_6210_() {
        Direction current = this.f_31699_;
        BlockPos anchor = this.f_31698_;
        double prevX = this.m_20185_();
        double prevY = this.m_20186_();
        double prevZ = this.m_20189_();
        super.m_6210_();
        this.m_20343_(prevX, prevY, prevZ);
        this.f_31698_ = anchor;
        if (current != null) {
            this.m_6022_(current);
        }
    }

    public void moveToRelative(double x, double y, double z) {
        BlockPos delta = new BlockPos(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_());
        this.f_31698_ = this.f_31698_.m_141952_((Vec3i)delta);
        this.m_7087_();
    }
}

