/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.vehicle;

import com.google.common.collect.Lists;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.blocks.parkBlocks.TourRailBlock;
import net.vit.jurassicreborn.common.entities.vehicle.InterpValue;
import net.vit.jurassicreborn.common.entities.vehicle.VehicleEntity;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.network.FordExplorerChangeStateMessage;
import net.vit.jurassicreborn.common.network.FordExplorerUpdatePositionStateMessage;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.util.MathUtils;

public class FordExplorerEntity
extends VehicleEntity {
    private static final EntityDataAccessor<Boolean> ON_RAILS = SynchedEntityData.m_135353_(FordExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final BlockPos INACTIVE = new BlockPos(-1, -1, -1);
    public BlockPos prevRailTracks = INACTIVE;
    public BlockPos railTracks = INACTIVE;
    public BlockPos prevPos = INACTIVE;
    private boolean prevOnRails;
    private boolean lastDirBackwards;
    public final MinecartLogic minecart = new MinecartLogic();
    private final InterpValue rotationYawInterp = new InterpValue(this, 4.0);

    public boolean isOnRails() {
        return (Boolean)this.f_19804_.m_135370_(ON_RAILS);
    }

    public void setOnRails(boolean v) {
        this.f_19804_.m_135381_(ON_RAILS, (Object)v);
    }

    public FordExplorerEntity(EntityType<? extends VehicleEntity> type, Level level) {
        super(type, level);
        this.speedModifier = 0.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        BlockPos start = this.m_142538_();
        if (!this.f_19853_.f_46443_) {
            this.handleRailDetection();
        }
        if (((Boolean)this.f_19804_.m_135370_(ON_RAILS)).booleanValue()) {
            this.minecart.tick();
            Vector4f v = this.wheeldata.carVector;
            this.backValue.setTarget(this.calculateWheelHeight(v.m_123615_(), false));
            this.frontValue.setTarget(this.calculateWheelHeight(v.m_123617_(), false));
            this.leftValue.setTarget(this.m_20186_());
            this.rightValue.setTarget(this.m_20186_());
        }
        if (!start.equals((Object)this.m_142538_())) {
            this.prevPos = this.m_142538_();
        }
        this.prevOnRails = this.isOnRails();
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isOnRails()) {
            if (this.canPassengerSteer() && (this.m_20197_().isEmpty() || !(this.m_20197_().get(0) instanceof Player))) {
                this.setControlState((byte)0);
            }
        } else {
            this.rotationYawInterp.reset((double)this.m_146908_() - 180.0);
        }
        if (this.forward()) {
            this.lastDirBackwards = false;
        } else if (this.backward()) {
            this.lastDirBackwards = true;
        }
    }

    private void handleRailDetection() {
        boolean wasRail;
        BlockPos above;
        BlockPos below;
        BlockPos rail = this.m_142538_();
        boolean isRail = this.f_19853_.m_8055_(rail).m_60734_() instanceof TourRailBlock;
        if (!isRail) {
            rail = rail.m_7495_();
            isRail = this.f_19853_.m_8055_(rail).m_60734_() instanceof TourRailBlock;
        }
        if (!isRail && this.f_19853_.m_8055_(below = rail.m_7495_()).m_60734_() instanceof TourRailBlock && Arrays.asList(TourRailBlock.EnumRailDirection.ASCENDING_EAST, TourRailBlock.EnumRailDirection.ASCENDING_NORTH, TourRailBlock.EnumRailDirection.ASCENDING_SOUTH, TourRailBlock.EnumRailDirection.ASCENDING_WEST).contains(TourRailBlock.getRailDirection(this.f_19853_, below))) {
            rail = below;
            isRail = true;
        }
        if (!isRail && this.f_19853_.m_8055_(above = rail.m_7494_()).m_60734_() instanceof TourRailBlock && Arrays.asList(TourRailBlock.EnumRailDirection.ASCENDING_EAST, TourRailBlock.EnumRailDirection.ASCENDING_NORTH, TourRailBlock.EnumRailDirection.ASCENDING_SOUTH, TourRailBlock.EnumRailDirection.ASCENDING_WEST).contains(TourRailBlock.getRailDirection(this.f_19853_, above))) {
            rail = above;
            isRail = true;
        }
        if ((wasRail = ((Boolean)this.f_19804_.m_135370_(ON_RAILS)).booleanValue()) != isRail) {
            if (isRail) {
                this.minecart.isInReverse = this.lastDirBackwards;
            }
            this.f_19804_.m_135381_(ON_RAILS, (Object)isRail);
            this.m_6210_();
            Network.sendToAllNear(this.f_19853_, this.m_142538_(), new FordExplorerChangeStateMessage(this.m_142049_(), isRail));
        }
        BlockPos blockPos = this.railTracks = isRail ? rail : INACTIVE;
        if (!this.railTracks.equals((Object)this.prevRailTracks)) {
            Network.sendToAllNear(this.f_19853_, this.m_142538_(), new FordExplorerUpdatePositionStateMessage(this.m_142049_(), rail));
        }
        this.prevRailTracks = this.railTracks;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return (Boolean)this.f_19804_.m_135370_(ON_RAILS) != false ? EntityDimensions.m_20398_((float)0.75f, (float)0.25f) : EntityDimensions.m_20398_((float)3.0f, (float)2.5f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    @Override
    protected VehicleEntity.Seat[] createSeats() {
        return new VehicleEntity.Seat[]{new VehicleEntity.Seat(0.563f, 0.45f, 0.4f, 0.5f, 0.25f), new VehicleEntity.Seat(-0.563f, 0.45f, 0.4f, 0.5f, 0.25f), new VehicleEntity.Seat(0.563f, 0.45f, -1.0f, 0.5f, 0.25f), new VehicleEntity.Seat(-0.563f, 0.45f, -1.0f, 0.5f, 0.25f)};
    }

    @Override
    protected void dropFromLootTable(boolean causedByPlayer) {
        if (!this.f_19853_.f_46443_) {
            this.m_19998_((ItemLike)ModItems.FORD_EXPLORER_SNOW.get());
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ON_RAILS, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("OnRails", ((Boolean)this.f_19804_.m_135370_(ON_RAILS)).booleanValue());
        tag.m_128356_("RailPos", this.railTracks.m_121878_());
        tag.m_128356_("PrevPos", this.prevPos.m_121878_());
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ON_RAILS, (Object)tag.m_128471_("OnRails"));
        this.railTracks = BlockPos.m_122022_((long)tag.m_128454_("RailPos"));
        this.prevPos = BlockPos.m_122022_((long)tag.m_128454_("PrevPos"));
    }

    @Nonnull
    public Direction getAdjustedHorizontalFacing() {
        return (Boolean)this.f_19804_.m_135370_(ON_RAILS) != false ? this.minecart.getAdjustedHorizontalFacing() : Direction.m_122364_((double)this.m_146908_());
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    protected VehicleEntity.WheelData createWheels() {
        return new VehicleEntity.WheelData(1.0, 2.0, -1.0, -2.2);
    }

    @Override
    public void dropItems() {
    }

    @Override
    public Vec2 getBackWheelRotationPoint() {
        Vec2 p = super.getBackWheelRotationPoint();
        return new Vec2(p.f_82470_, (Boolean)this.f_19804_.m_135370_(ON_RAILS) != false ? 0.0f : p.f_82471_);
    }

    public float m_6143_() {
        return 2.25f;
    }

    @Override
    protected void doBlockCollisions() {
        if (!this.isOnRails()) {
            this.doBlockCollisions();
        }
    }

    public boolean m_142559_() {
        return super.m_142559_();
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public double calculateWheelHeight(double raw, boolean front) {
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ / 2.0;
    }

    public class MinecartLogic {
        private boolean isInReverse;
        private boolean prevKeyDown;
        private double adjustedRotationYaw;

        public Direction getAdjustedHorizontalFacing() {
            Direction f = Direction.m_122364_((double)FordExplorerEntity.this.m_146908_());
            return this.isInReverse ? f.m_122424_() : f;
        }

        public void tick() {
            FordExplorerEntity.this.rotationDelta *= 0.8f;
            for (int i = 0; i < 4; ++i) {
                ArrayList removed = Lists.newArrayList();
                FordExplorerEntity.this.wheelDataList[i].forEach(w -> w.onUpdate(removed));
                removed.forEach(FordExplorerEntity.this.wheelDataList[i]::remove);
            }
            FordExplorerEntity.this.allWheels.forEach(FordExplorerEntity.this::processWheel);
            FordExplorerEntity.this.spawnWheelParticles();
            if (FordExplorerEntity.this.m_20186_() < -64.0) {
                FordExplorerEntity.this.m_146870_();
            }
            if (FordExplorerEntity.this.railTracks == INACTIVE || FordExplorerEntity.this.m_20197_().isEmpty()) {
                return;
            }
            this.moveAlongTrack();
            if (!FordExplorerEntity.this.f_19853_.f_46443_) {
                FordExplorerEntity.this.doBlockCollisions();
                FordExplorerEntity.this.m_146926_(0.0f);
                FordExplorerEntity.this.m_20073_();
            }
        }

        private void moveAlongTrack() {
            double d15;
            double d10;
            double diff;
            double d5;
            FordExplorerEntity.this.f_19789_ = 0.0f;
            Vec3 vecStart = this.getRailPos();
            if (vecStart == null) {
                return;
            }
            FordExplorerEntity.this.m_6034_(vecStart.f_82479_, vecStart.f_82480_, vecStart.f_82481_);
            double slope = 0.0078125;
            TourRailBlock.EnumRailDirection dir = TourRailBlock.getRailDirection(FordExplorerEntity.this.f_19853_, FordExplorerEntity.this.railTracks);
            Direction facing = this.getFacingDir();
            switch (dir) {
                case ASCENDING_EAST: {
                    FordExplorerEntity.this.m_20256_(FordExplorerEntity.this.m_20184_().m_82520_(-slope, 0.0, 0.0));
                    FordExplorerEntity.this.m_6034_(FordExplorerEntity.this.m_20185_(), FordExplorerEntity.this.m_20186_() + 1.0, FordExplorerEntity.this.m_20189_());
                    break;
                }
                case ASCENDING_WEST: {
                    FordExplorerEntity.this.m_20256_(FordExplorerEntity.this.m_20184_().m_82520_(slope, 0.0, 0.0));
                    FordExplorerEntity.this.m_6034_(FordExplorerEntity.this.m_20185_(), FordExplorerEntity.this.m_20186_() + 1.0, FordExplorerEntity.this.m_20189_());
                    break;
                }
                case ASCENDING_NORTH: {
                    FordExplorerEntity.this.m_20256_(FordExplorerEntity.this.m_20184_().m_82520_(0.0, 0.0, slope));
                    FordExplorerEntity.this.m_6034_(FordExplorerEntity.this.m_20185_(), FordExplorerEntity.this.m_20186_() + 1.0, FordExplorerEntity.this.m_20189_());
                    break;
                }
                case ASCENDING_SOUTH: {
                    FordExplorerEntity.this.m_20256_(FordExplorerEntity.this.m_20184_().m_82520_(0.0, 0.0, -slope));
                    FordExplorerEntity.this.m_6034_(FordExplorerEntity.this.m_20185_(), FordExplorerEntity.this.m_20186_() + 1.0, FordExplorerEntity.this.m_20189_());
                }
            }
            double d1 = dir.getBackwardsX(facing) - dir.getForwardX(facing);
            double d2 = dir.getBackwardsZ(facing) - dir.getForwardZ(facing);
            double d3 = Math.sqrt(d1 * d1 + d2 * d2);
            Vec3 motion = FordExplorerEntity.this.m_20184_();
            double d4 = motion.f_82479_ * d1 + motion.f_82481_ * d2;
            if (d4 < 0.0) {
                d1 = -d1;
                d2 = -d2;
            }
            if ((d5 = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) > 2.0) {
                d5 = 2.0;
            }
            double dirMul = 1.0;
            if (FordExplorerEntity.this.forward()) {
                if (!this.prevKeyDown && this.isInReverse) {
                    dirMul = -1.0;
                }
                this.isInReverse = false;
                this.prevKeyDown = true;
            } else if (FordExplorerEntity.this.backward()) {
                if (!this.prevKeyDown && !this.isInReverse) {
                    dirMul = -1.0;
                }
                this.isInReverse = true;
                this.prevKeyDown = true;
            } else {
                this.prevKeyDown = false;
            }
            if (!FordExplorerEntity.this.f_19853_.f_46443_) {
                d5 *= dirMul;
            }
            double motionX = d5 * d1 / d3;
            double motionZ = d5 * d2 / d3;
            Vec3 pos = FordExplorerEntity.this.m_20182_();
            Vec3 dirVec = new Vec3(-d1, 0.0, d2).m_82549_(pos);
            double target = MathUtils.cosineFromPoints(pos.m_82520_(0.0, 0.0, 1.0), dirVec, pos);
            if (dirVec.f_82479_ < pos.f_82479_) {
                target = -target;
            }
            this.adjustedRotationYaw = target;
            if (this.isInReverse) {
                target += 180.0;
            }
            do {
                diff = Math.abs(FordExplorerEntity.this.rotationYawInterp.getCurrent() - target);
                double d23 = Math.abs(FordExplorerEntity.this.rotationYawInterp.getCurrent() - (target + 360.0));
                double d24 = Math.abs(FordExplorerEntity.this.rotationYawInterp.getCurrent() - (target - 360.0));
                if (d23 < diff) {
                    target += 360.0;
                    continue;
                }
                if (!(d24 < diff)) continue;
                target -= 360.0;
            } while (diff > 180.0);
            target = (double)Math.round(target * 100.0) / 100.0;
            FordExplorerEntity.this.rotationYawInterp.setSpeed(this.getSpeedType().modifier * 4.0f);
            if (!FordExplorerEntity.this.prevOnRails) {
                FordExplorerEntity.this.rotationYawInterp.reset(target);
            } else if (dirMul != -1.0) {
                FordExplorerEntity.this.rotationYawInterp.setTarget(target);
            }
            FordExplorerEntity.this.m_146922_((float)FordExplorerEntity.this.rotationYawInterp.getCurrent());
            double d18 = (double)FordExplorerEntity.this.railTracks.m_123341_() + 0.5 + (double)dir.getForwardX(facing) * 0.5;
            double d19 = (double)FordExplorerEntity.this.railTracks.m_123343_() + 0.5 + (double)dir.getForwardZ(facing) * 0.5;
            double d20 = (double)FordExplorerEntity.this.railTracks.m_123341_() + 0.5 + (double)dir.getBackwardsX(facing) * 0.5;
            double d21 = (double)FordExplorerEntity.this.railTracks.m_123343_() + 0.5 + (double)dir.getBackwardsZ(facing) * 0.5;
            d1 = d20 - d18;
            d2 = d21 - d19;
            if (d1 == 0.0) {
                FordExplorerEntity.this.m_6034_((double)FordExplorerEntity.this.railTracks.m_123341_() + 0.5, FordExplorerEntity.this.m_20186_(), FordExplorerEntity.this.m_20189_());
                d10 = FordExplorerEntity.this.m_20189_() - (double)FordExplorerEntity.this.railTracks.m_123343_();
            } else if (d2 == 0.0) {
                FordExplorerEntity.this.m_6034_(FordExplorerEntity.this.m_20185_(), FordExplorerEntity.this.m_20186_(), (double)FordExplorerEntity.this.railTracks.m_123343_() + 0.5);
                d10 = FordExplorerEntity.this.m_20185_() - (double)FordExplorerEntity.this.railTracks.m_123341_();
            } else {
                double d11 = FordExplorerEntity.this.m_20185_() - d18;
                double d12 = FordExplorerEntity.this.m_20189_() - d19;
                d10 = (d11 * d1 + d12 * d2) * 2.0;
            }
            double newX = d18 + d1 * d10;
            double newZ = d19 + d2 * d10;
            FordExplorerEntity.this.m_6034_(newX, FordExplorerEntity.this.m_20186_(), newZ);
            this.moveMinecartOnRail(motionX, motionZ);
            double drag = FordExplorerEntity.this.m_20160_() ? 0.9 : 0.75;
            motionX *= drag;
            motionZ *= drag;
            Vec3 vecEnd = this.getRailPos();
            if (vecEnd != null && vecStart != null) {
                double d14 = (vecStart.f_82480_ - vecEnd.f_82480_) * 0.05;
                d5 = Math.sqrt(motionX * motionX + motionZ * motionZ);
                if (d5 > 0.0) {
                    motionX = motionX / d5 * (d5 + d14);
                    motionZ = motionZ / d5 * (d5 + d14);
                }
            }
            int j = Mth.m_14107_((double)FordExplorerEntity.this.m_20185_());
            int i = Mth.m_14107_((double)FordExplorerEntity.this.m_20189_());
            if (j != FordExplorerEntity.this.railTracks.m_123341_() || i != FordExplorerEntity.this.railTracks.m_123343_()) {
                d5 = Math.sqrt(motionX * motionX + motionZ * motionZ);
                motionX = d5 * (double)(j - FordExplorerEntity.this.railTracks.m_123341_());
                motionZ = d5 * (double)(i - FordExplorerEntity.this.railTracks.m_123343_());
            }
            if ((d15 = Math.sqrt(motionX * motionX + motionZ * motionZ)) == 0.0) {
                d15 = 1.0;
            }
            double d16 = 0.06;
            motionX += motionX / d15 * d16;
            motionZ += motionZ / d15 * d16;
            FordExplorerEntity.this.m_20334_(motionX, FordExplorerEntity.this.m_20184_().f_82480_, motionZ);
        }

        private Vec3 getRailPos() {
            BlockState state = FordExplorerEntity.this.f_19853_.m_8055_(FordExplorerEntity.this.railTracks);
            if (!(state.m_60734_() instanceof TourRailBlock)) {
                return null;
            }
            TourRailBlock.EnumRailDirection dir = TourRailBlock.getRailDirection(FordExplorerEntity.this.f_19853_, FordExplorerEntity.this.railTracks);
            Direction facing = this.getFacingDir();
            double startX = (double)FordExplorerEntity.this.railTracks.m_123341_() + 0.5 + (double)dir.getForwardX(facing) * 0.5;
            double startY = (double)FordExplorerEntity.this.railTracks.m_123342_() + 0.0625 + (double)dir.getForwardY(facing) * 0.5;
            double startZ = (double)FordExplorerEntity.this.railTracks.m_123343_() + 0.5 + (double)dir.getForwardZ(facing) * 0.5;
            double endX = (double)FordExplorerEntity.this.railTracks.m_123341_() + 0.5 + (double)dir.getBackwardsX(facing) * 0.5;
            double endY = (double)FordExplorerEntity.this.railTracks.m_123342_() + 0.0625 + (double)dir.getBackwardsY(facing) * 0.5;
            double endZ = (double)FordExplorerEntity.this.railTracks.m_123343_() + 0.5 + (double)dir.getBackwardsZ(facing) * 0.5;
            double dx = endX - startX;
            double dy = endY - startY;
            double dz = endZ - startZ;
            double len = Math.sqrt(dx * dx + dz * dz);
            if (len == 0.0) {
                return new Vec3(startX, startY, startZ);
            }
            double t = ((FordExplorerEntity.this.m_20185_() - startX) * dx + (FordExplorerEntity.this.m_20189_() - startZ) * dz) / (len * len);
            t = Mth.m_14008_((double)t, (double)0.0, (double)1.0);
            double x = startX + dx * t;
            double y = startY + dy * t;
            double z = startZ + dz * t;
            return new Vec3(x, y, z);
        }

        private void moveMinecartOnRail(double mx, double mz) {
            if (mx == 0.0 && mz == 0.0 && !FordExplorerEntity.this.m_20197_().isEmpty()) {
                Vec3 look = FordExplorerEntity.this.m_20252_(1.0f);
                mx = look.f_82479_;
                mz = look.f_82481_;
            }
            double max = this.getSpeedType().modifier / 8.0f;
            max = Math.min(max, 0.4);
            mx = Mth.m_14008_((double)mx, (double)(-max), (double)max);
            mz = Mth.m_14008_((double)mz, (double)(-max), (double)max);
            FordExplorerEntity.this.m_6478_(MoverType.SELF, new Vec3(mx, 0.0, mz));
        }

        private VehicleEntity.Speed getSpeedType() {
            return ((TourRailBlock)FordExplorerEntity.this.f_19853_.m_8055_(FordExplorerEntity.this.railTracks).m_60734_()).getSpeedType().getSpeed(FordExplorerEntity.this.getSpeed());
        }

        private Direction getFacingDir() {
            Direction facing = Direction.m_122364_((double)((float)this.adjustedRotationYaw));
            if (this.isInReverse) {
                facing = facing.m_122424_();
            }
            return facing;
        }
    }
}

