/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.vehicle;

import java.util.List;
import net.minecraft.world.phys.Vec3;

public class WheelParticleData {
    private int age;
    private final Vec3 pos;
    private final Vec3 opposite;
    private final int maxAge = 200;
    private final long worldTime;
    private boolean render = true;

    public WheelParticleData(Vec3 pos, Vec3 opposite, long worldTime) {
        this.pos = pos;
        this.opposite = opposite;
        this.worldTime = worldTime;
    }

    public WheelParticleData setShouldRender(boolean r) {
        this.render = r;
        return this;
    }

    public boolean shouldRender() {
        return this.render;
    }

    public Vec3 getPosition() {
        return this.pos;
    }

    public Vec3 getOppositePosition() {
        return this.opposite;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public void tick(List<WheelParticleData> dead) {
        if (++this.age >= 200) {
            dead.add(this);
        }
    }

    public void onUpdate(List<WheelParticleData> markedRemoved) {
        if (this.age++ >= this.maxAge) {
            markedRemoved.add(this);
        }
    }

    public float getAlpha(float partial) {
        if (this.age > 199) {
            return 0.0f;
        }
        float f = (float)Math.pow(((double)this.age + (double)partial) / 200.0, 2.0);
        float f1 = 2.0f - f * 2.0f;
        return Math.min(f1, 1.0f) * 0.3f;
    }
}

