/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.api.SequencableItem;

public class PlantSoftTissueItem
extends Item
implements SequencableItem {
    private final PlantDNA defaultDNA;

    public PlantSoftTissueItem(Item.Properties properties, Plant plant) {
        super(properties);
        this.defaultDNA = new PlantDNA(plant.getId(), 0);
    }

    public Component m_7626_(ItemStack stack) {
        String plantName = PlantHandler.getPlantById(this.defaultDNA.getPlant()).getName();
        return new TranslatableComponent("item.jurassicreborn.plant_soft_tissue", new Object[]{plantName});
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        ArrayList list = Lists.newArrayList();
        CompoundTag nbt = new CompoundTag();
        PlantDNA dna = new PlantDNA(this.defaultDNA.getPlant(), -1);
        dna.writeToNBT(nbt);
        ItemStack output = new ItemStack((ItemLike)ModItems.STORAGE_DISC.get(), 1);
        output.m_41751_(nbt);
        StorageDiscItem.applyCustomModelData(output);
        list.add(Pair.of((Object)Float.valueOf(100.0f), (Object)output));
        return list;
    }

    @Override
    public boolean isSequencable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getSequenceOutput(ItemStack stack, Random random) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_("DNA") || !nbt.m_128469_("DNA").m_128441_("Plant")) {
            nbt = new CompoundTag();
            this.initDnaCompound(random, nbt);
        }
        ItemStack output = new ItemStack((ItemLike)ModItems.STORAGE_DISC.get(), 1);
        output.m_41751_(nbt);
        StorageDiscItem.applyCustomModelData(output);
        return output;
    }

    private void initDnaCompound(Random random, CompoundTag outTag) {
        int quality = Math.abs(SequencableItem.randomQuality(random)) / 2;
        PlantDNA dna = new PlantDNA(this.defaultDNA.getPlant(), quality);
        dna.writeToNBT(outTag);
    }
}

